/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.core.data.factories.FlowDataFactory;
import fiftyone.pipeline.core.flowelements.FlowDataFactoryDefault;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.ParallelElements;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineDefault;
import fiftyone.pipeline.core.services.PipelineService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineBuilderBase<T extends PipelineBuilderBase> {
    protected final ILoggerFactory loggerFactory;
    protected final Logger logger;
    protected final List<FlowElement> flowElements = new ArrayList<FlowElement>();
    protected final List<PipelineService> services = new ArrayList<PipelineService>();
    protected boolean autoCloseElements = false;
    protected boolean suppressProcessExceptions = false;

    public PipelineBuilderBase() {
        this(LoggerFactory.getILoggerFactory());
    }

    public PipelineBuilderBase(ILoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = loggerFactory.getLogger(this.getClass().getName());
    }

    protected List<FlowElement> getFlowElements() {
        return this.flowElements;
    }

    public Pipeline build() throws Exception {
        this.onPreBuild();
        PipelineDefault pipeline = new PipelineDefault(this.loggerFactory.getLogger(Pipeline.class.getName()), this.flowElements, this.getFlowDataFactory(), this.autoCloseElements, this.suppressProcessExceptions);
        this.addServicesToPipeline(pipeline);
        return pipeline;
    }

    public T addFlowElement(FlowElement element) {
        if (element.isClosed()) {
            throw new IllegalStateException("The element '" + element.getClass().getSimpleName() + "' was closed.");
        }
        this.flowElements.add(element);
        return (T)this;
    }

    public T addFlowElementsParallel(FlowElement[] elements) {
        for (FlowElement element : elements) {
            if (!element.isClosed()) continue;
            throw new IllegalStateException("The element '" + element.getClass().getSimpleName() + "' was closed.");
        }
        ParallelElements parallelElements = new ParallelElements(this.loggerFactory.getLogger(ParallelElements.class.getName()), Arrays.asList(elements));
        this.flowElements.add(parallelElements);
        return (T)this;
    }

    public T addService(PipelineService service) {
        this.services.add(service);
        return (T)this;
    }

    protected void addServicesToPipeline(Pipeline pipeline) {
        if (!pipeline.addServices(this.services)) {
            for (PipelineService service : this.services) {
                pipeline.addService(service);
            }
        }
    }

    public T setAutoCloseElements(boolean autoClose) {
        this.autoCloseElements = autoClose;
        return (T)this;
    }

    public T setSuppressProcessException(boolean suppress) {
        this.suppressProcessExceptions = suppress;
        return (T)this;
    }

    protected void onPreBuild() {
    }

    FlowDataFactory getFlowDataFactory() {
        return new FlowDataFactoryDefault(this.loggerFactory);
    }
}

