/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.flowelements;

import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterAggregator;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.FlowError;
import fiftyone.pipeline.core.data.factories.FlowDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineDataException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.ParallelElements;
import fiftyone.pipeline.core.flowelements.PipelineInternal;
import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.exceptions.AggregateException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;

class PipelineDefault
implements PipelineInternal {
    private final Logger logger;
    private final FlowDataFactory flowDataFactory;
    private final boolean autoDisposeElements;
    private final boolean suppressProcessExceptions;
    private final Map<String, Map<String, ElementPropertyMetaData>> elementAvailableProperties;
    private final Object lock = new Object();
    private volatile boolean isClosed = false;
    private boolean isConcurrent;
    private final List<FlowElement> flowElements;
    private final List<PipelineService> services;
    private EvidenceKeyFilter evidenceKeyFilter = null;
    private final Map<Class, List<FlowElement>> elementsByType = new HashMap<Class, List<FlowElement>>();
    private final ConcurrentMap<String, ElementPropertyMetaData> metaDataByPropertyName = new ConcurrentHashMap<String, ElementPropertyMetaData>();

    PipelineDefault(Logger logger, List<FlowElement> flowElements, FlowDataFactory flowDataFactory, boolean autoDisposeElements, boolean suppressProcessExceptions) {
        this.logger = logger;
        this.flowDataFactory = flowDataFactory;
        this.flowElements = flowElements;
        this.services = new ArrayList<PipelineService>();
        this.autoDisposeElements = autoDisposeElements;
        this.suppressProcessExceptions = suppressProcessExceptions;
        this.addElementsByType(flowElements);
        this.isConcurrent = false;
        for (FlowElement element : this.flowElements) {
            this.isConcurrent = this.isConcurrent || element.isConcurrent();
        }
        this.elementAvailableProperties = this.getElementAvailableProperties(flowElements);
        logger.debug("Pipeline '" + this.hashCode() + "' created.");
    }

    @Override
    public void addService(PipelineService service) {
        this.services.add(service);
    }

    @Override
    public boolean addServices(Collection<PipelineService> services) {
        return this.services.addAll(services);
    }

    @Override
    public List<PipelineService> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public FlowData createFlowData() throws RuntimeException {
        if (this.isClosed) {
            throw new RuntimeException("Pipeline is closed.");
        }
        return this.flowDataFactory.create(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvidenceKeyFilter getEvidenceKeyFilter() {
        if (this.evidenceKeyFilter == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.evidenceKeyFilter == null) {
                    EvidenceKeyFilterAggregator filter = new EvidenceKeyFilterAggregator();
                    for (FlowElement element : this.flowElements) {
                        filter.addFilter(element.getEvidenceKeyFilter());
                    }
                    this.evidenceKeyFilter = filter;
                }
            }
        }
        return this.evidenceKeyFilter;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private Map<String, Map<String, ElementPropertyMetaData>> getElementAvailableProperties(List<FlowElement> elements) {
        TreeMap<String, Map<String, ElementPropertyMetaData>> map = new TreeMap<String, Map<String, ElementPropertyMetaData>>(String.CASE_INSENSITIVE_ORDER);
        this.addAvailableProperties(elements, map);
        TreeMap mapOfReadonly = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : map.entrySet()) {
            mapOfReadonly.put((String)entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
        }
        return Collections.unmodifiableMap(mapOfReadonly);
    }

    private void addAvailableProperties(List<FlowElement> elements, Map<String, Map<String, ElementPropertyMetaData>> map) {
        for (FlowElement element : elements) {
            if (element instanceof ParallelElements) {
                this.addAvailableProperties(((ParallelElements)element).getFlowElements(), map);
                continue;
            }
            if (!map.containsKey(element.getElementDataKey())) {
                map.put(element.getElementDataKey(), new TreeMap(String.CASE_INSENSITIVE_ORDER));
            }
            Map<String, ElementPropertyMetaData> availableElementProperties = map.get(element.getElementDataKey());
            for (Object propertyObject : element.getProperties()) {
                ElementPropertyMetaData property = (ElementPropertyMetaData)propertyObject;
                if (!property.isAvailable() || availableElementProperties.containsKey(property.getName())) continue;
                availableElementProperties.put(property.getName(), property);
            }
        }
    }

    private void addElementsByType(List<FlowElement> elements) {
        for (FlowElement element : elements) {
            element.addPipeline(this);
            Class<?> type = element.getClass();
            if (element instanceof ParallelElements) {
                this.addElementsByType(((ParallelElements)element).getFlowElements());
                continue;
            }
            if (!this.elementsByType.containsKey(type)) {
                this.elementsByType.put(type, new ArrayList());
            }
            this.elementsByType.get(type).add(element);
        }
    }

    private <T extends FlowElement> boolean anyAssignableFrom(Map<Class, List<FlowElement>> elements, Class<T> type) {
        for (Class element : elements.keySet()) {
            if (!type.isAssignableFrom(element)) continue;
            return true;
        }
        return false;
    }

    private <T extends FlowElement> List<List<FlowElement>> getElementsWhereAssignableFrom(Map<Class, List<FlowElement>> elements, Class<T> type) {
        ArrayList<List<FlowElement>> result = new ArrayList<List<FlowElement>>();
        for (Map.Entry<Class, List<FlowElement>> element : elements.entrySet()) {
            if (!type.isAssignableFrom(element.getKey())) continue;
            result.add(element.getValue());
        }
        return result;
    }

    @Override
    public <T extends FlowElement> T getElement(Class<T> type) {
        List<List<FlowElement>> matches;
        FlowElement result = null;
        if (this.elementsByType.containsKey(type)) {
            try {
                result = (FlowElement)type.cast(this.elementsByType.get(type).get(0));
            }
            catch (ClassCastException e) {
                result = null;
            }
        } else if (this.anyAssignableFrom(this.elementsByType, type) && (matches = this.getElementsWhereAssignableFrom(this.elementsByType, type)).size() == 1 && matches.get(0).size() == 1) {
            result = matches.get(0).get(0);
        }
        return (T)result;
    }

    @Override
    public List<FlowElement> getFlowElements() {
        return Collections.unmodifiableList(this.flowElements);
    }

    @Override
    public Map<String, Map<String, ElementPropertyMetaData>> getElementAvailableProperties() {
        return Collections.unmodifiableMap(this.elementAvailableProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closing) throws Exception {
        if (!this.isClosed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isClosed) {
                    this.isClosed = true;
                    if (closing && this.autoDisposeElements) {
                        ArrayList<Exception> exceptions = new ArrayList<Exception>();
                        for (FlowElement element : this.flowElements) {
                            try {
                                element.close();
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                        }
                        for (PipelineService service : this.services) {
                            if (service instanceof Closeable) {
                                ((Closeable)((Object)service)).close();
                                continue;
                            }
                            if (!(service instanceof AutoCloseable)) continue;
                            try {
                                ((AutoCloseable)((Object)service)).close();
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                        }
                        if (exceptions.size() > 0) {
                            throw new Exception("One or more exceptions occurred while closing the pipeline", (Throwable)exceptions.get(0));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.logger.debug("Pipeline '" + this.hashCode() + "' closed.");
        this.close(true);
    }

    @Override
    public void process(FlowData data) {
        this.logger.debug("Pipeline '" + this.hashCode() + "' started processing.");
        if (this.isClosed) {
            throw new RuntimeException("Pipeline is closed");
        }
        for (FlowElement element : this.flowElements) {
            try {
                element.process(data);
                if (!data.isStopped()) continue;
                break;
            }
            catch (Exception ex) {
                data.addError(ex, element);
            }
        }
        if (data.getErrors() != null && data.getErrors().size() > 0 && !this.suppressProcessExceptions) {
            throw new AggregateException("Exception(s) occurred processing evidence.", data.getErrors().stream().map(FlowError::getThrowable).collect(Collectors.toList()));
        }
        this.logger.debug("Pipeline '" + this.hashCode() + "' finished processing.");
    }

    @Override
    public ElementPropertyMetaData getMetaDataForProperty(String propertyName) throws PipelineDataException {
        ElementPropertyMetaData result;
        if (this.metaDataByPropertyName.containsKey(propertyName)) {
            result = (ElementPropertyMetaData)this.metaDataByPropertyName.get(propertyName);
        } else {
            String message;
            ArrayList<ElementPropertyMetaData> properties = new ArrayList<ElementPropertyMetaData>();
            for (FlowElement element : this.flowElements) {
                for (Object property : element.getProperties()) {
                    if (!((ElementPropertyMetaData)property).getName().equalsIgnoreCase(propertyName)) continue;
                    properties.add((ElementPropertyMetaData)property);
                }
            }
            if (properties.size() > 1) {
                message = "Multiple matches for property '" + propertyName + "'. Flow elements that populate this property are: '" + Arrays.toString(properties.toArray()) + "'";
                this.logger.debug(message);
                throw new PipelineDataException(message);
            }
            if (properties.size() == 0) {
                message = "Could not find property '" + propertyName + "'.";
                this.logger.debug(message);
                throw new PipelineDataException(message);
            }
            result = (ElementPropertyMetaData)properties.get(0);
            this.metaDataByPropertyName.putIfAbsent(propertyName, result);
        }
        return result;
    }
}

