/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.core.typed;

import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.exceptions.PipelineDataException;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.core.typed.TypedKeyMap;
import fiftyone.pipeline.util.StringManipulation;
import java.io.Closeable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypedKeyMapBuilder {
    private final TypedKeyMap _map;

    public TypedKeyMapBuilder(boolean isConcurrent) {
        this._map = isConcurrent ? new TypedKeyMapConcurrent() : new TypedKeyMapInternal();
    }

    public <T> TypedKeyMapBuilder put(TypedKey<T> typedKey, T value) {
        this._map.put(typedKey, value);
        return this;
    }

    public TypedKeyMap build() {
        return this._map;
    }

    private static class TypedKeyMapConcurrent
    extends TypedKeyMapInternal {
        private TypedKeyMapConcurrent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void put(TypedKey<T> typedKey, T value) {
            TypedKeyMapConcurrent typedKeyMapConcurrent = this;
            synchronized (typedKeyMapConcurrent) {
                super.put(typedKey, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T removeIfExists(TypedKey<T> typedKey) {
            TypedKeyMapConcurrent typedKeyMapConcurrent = this;
            synchronized (typedKeyMapConcurrent) {
                return super.removeIfExists(typedKey);
            }
        }
    }

    private static class TypedKeyMapInternal
    implements TypedKeyMap,
    Map<String, Object>,
    Closeable {
        private static final Entry[] emptyEntryPair = new Entry[]{null, null};
        private Entry _head = null;

        private TypedKeyMapInternal() {
        }

        private Entry[] findWithPrevious(String typedKeyName) {
            Entry current = this._head;
            if (current != null) {
                if (current._key.getName().equals(typedKeyName)) {
                    return new Entry[]{null, current};
                }
                while (current._next != null) {
                    if (current._next._key.getName().equals(typedKeyName)) {
                        return new Entry[]{current, current._next};
                    }
                    current = current._next;
                }
            }
            return emptyEntryPair;
        }

        private Entry find(String typedKeyName) {
            return this.findWithPrevious(typedKeyName)[1];
        }

        private String getKeyMissingMessage(String key) {
            return "There is no data for '" + key + "' against this instance of '" + this.getClass().getSimpleName() + "'. Available keys are: " + StringManipulation.stringJoin(this.getKeys(), ", ");
        }

        @Override
        public <T> T get(TypedKey<T> typedKey) {
            Entry current = this.find(typedKey.getName());
            if (current != null) {
                return typedKey.getType().cast(current._value);
            }
            throw new NoSuchElementException(this.getKeyMissingMessage(typedKey.getName()));
        }

        @Override
        public <T> T get(Class<T> type) {
            ArrayList<Entry> matches = new ArrayList<Entry>();
            Entry current = this._head;
            while (current != null) {
                if (current._value.getClass().equals(type)) {
                    matches.add(current);
                }
                current = current._next;
            }
            if (matches.isEmpty()) {
                current = this._head;
                while (current != null) {
                    if (type.isAssignableFrom(current._value.getClass())) {
                        matches.add(current);
                    }
                    current = current._next;
                }
            }
            if (matches.size() == 1) {
                return type.cast(((Entry)matches.get((int)0))._value);
            }
            if (matches.size() == 0) {
                throw new PipelineDataException("This map contains no data matching type '" + type.getSimpleName() + "'");
            }
            throw new PipelineDataException("This map contains multiple data instances matching type '" + type.getSimpleName() + "'");
        }

        @Override
        public <T> TryGetResult<T> tryGet(TypedKey<T> key) {
            TryGetResult<T> result = new TryGetResult<T>();
            try {
                Entry current = this.find(key.getName());
                if (current != null) {
                    T value = key.getType().cast(current._value);
                    result.setValue(value);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public <T> T removeIfExists(TypedKey<T> typedKey) {
            Entry[] current = this.findWithPrevious(typedKey.getName());
            if (current[1] != null) {
                if (current[0] != null) {
                    current[0]._next = current[1]._next;
                }
                if (current[1] == this._head) {
                    this._head = current[1]._next;
                }
                Object value = current[1]._value;
                current[1].closeValue();
                current[1]._value = null;
                return value;
            }
            return null;
        }

        @Override
        public <T> void put(TypedKey<T> typedKey, T value) {
            Entry current = this.find(typedKey.getName());
            if (current != null) {
                if (current._value != null) {
                    current.closeValue();
                }
                current._value = value;
            } else {
                Entry<T> first = new Entry<T>(typedKey, value);
                first._next = this._head;
                this._head = first;
            }
        }

        @Override
        public int size() {
            int count = 0;
            Entry current = this._head;
            while (current != null) {
                ++count;
                current = current._next;
            }
            return count;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.containsKey((String)key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public Object get(Object key) {
            return this.get(new TypedKeyDefault((String)key, Object.class));
        }

        @Override
        public Object put(String key, Object value) {
            this.put(new TypedKeyDefault(key, Object.class), (T)value);
            return null;
        }

        @Override
        public Object remove(Object key) {
            this.removeIfExists(new TypedKeyDefault((String)key, Object.class));
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                this.put(new TypedKeyDefault(entry.getKey(), Object.class), (T)entry.getValue());
            }
        }

        @Override
        public void clear() {
            for (String key : this.keySet()) {
                this.remove(key);
            }
        }

        @Override
        public Set<String> keySet() {
            Entry current = this._head;
            HashSet<String> set = new HashSet<String>();
            while (current != null) {
                set.add(current._key.getName());
                current = current._next;
            }
            return set;
        }

        @Override
        public Collection<Object> values() {
            Entry current = this._head;
            HashSet<Object> set = new HashSet<Object>();
            while (current != null) {
                set.add(current._value);
                current = current._next;
            }
            return set;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            Entry current = this._head;
            HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
            while (current != null) {
                set.add(new AbstractMap.SimpleEntry(current._key.getName(), current._value));
                current = current._next;
            }
            return set;
        }

        @Override
        public List<String> getKeys() {
            Entry current = this._head;
            ArrayList<String> keys = new ArrayList<String>();
            while (current != null) {
                keys.add(current._key.getName());
                current = current._next;
            }
            return keys;
        }

        @Override
        public Map<String, Object> asStringKeyMap() {
            return this;
        }

        @Override
        public boolean containsKey(String key) {
            return this.find(key) != null;
        }

        @Override
        public <T> boolean containsKey(TypedKey<T> typedKey) {
            boolean result = false;
            Entry value = this.find(typedKey.getName());
            if (value != null && typedKey.getType().isAssignableFrom(value._value.getClass())) {
                result = true;
            }
            return result;
        }

        @Override
        public void close() {
            Entry current = this._head;
            while (current != null) {
                current.closeValue();
                current = current._next;
            }
        }

        private static class Entry<T> {
            final TypedKey<T> _key;
            T _value;
            Entry _next = null;

            Entry(TypedKey<T> key, T value) {
                this._key = key;
                this._value = value;
            }

            public void closeValue() {
                try {
                    if (this._value instanceof AutoCloseable) {
                        ((AutoCloseable)this._value).close();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(TypedKeyMapBuilder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

