/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.util;

import fiftyone.pipeline.annotations.AlternateName;
import fiftyone.pipeline.annotations.BuildArg;
import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.annotations.ElementBuilder;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.util.Check;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builders {
    private static final Logger logger = LoggerFactory.getLogger((String)"Builders");
    private static final Set<String> methodsSeen = new HashSet<String>();

    public static void doTable(PrintStream out) {
        for (Class<?> clazz : PipelineBuilder.getAvailableElementBuilders()) {
            out.println("# " + clazz.getName());
            out.println("| Method | Default | Class |");
            out.println("| --- | --- | --- |");
            for (Method method : clazz.getMethods()) {
                if (!method.getName().startsWith("set") && !method.getName().equals("build")) continue;
                out.print("| ");
                if (Objects.nonNull(method.getAnnotation(Deprecated.class))) {
                    out.print("Deprecated - ");
                }
                out.print(method.getName());
                out.print("(");
                out.print(Builders.getParameterDetails(method));
                out.print(") | ");
                out.print(Builders.getDefaultValue(method));
                out.print(" | " + method.getDeclaringClass().getName());
                out.println(" |");
            }
            out.println();
        }
    }

    public static void doXml(PrintStream out) {
        out.println("<PipelineOptions>");
        out.println("    <Elements>");
        for (Class<?> clazz : PipelineBuilder.getAvailableElementBuilders()) {
            methodsSeen.clear();
            out.println("        <!--<Element>");
            out.println("           <BuilderName>" + clazz.getSimpleName() + "</BuilderName>");
            ElementBuilder elementBuilder = clazz.getAnnotation(ElementBuilder.class);
            String alternateName = elementBuilder.alternateName();
            if (!alternateName.isEmpty()) {
                out.println("            <BuilderName>" + alternateName + "</BuilderName>");
            }
            out.println("            <BuildParameters>");
            if (Arrays.stream(clazz.getMethods()).noneMatch(m -> m.getName().startsWith("set"))) {
                logger.debug("No methods");
            }
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals("build")) continue;
                for (Parameter parameter : method.getParameters()) {
                    String methodDetail;
                    BuildArg buildArg = parameter.getAnnotation(BuildArg.class);
                    if (buildArg == null || !Check.notNullOrBlank(methodDetail = Builders.detailMethod(method, buildArg.value()))) continue;
                    out.println(methodDetail);
                }
            }
            for (Method method : clazz.getMethods()) {
                AlternateName alternateName1;
                if (!method.getName().startsWith("set")) continue;
                String methodDetail = Builders.detailMethod(method);
                if (Check.notNullOrBlank(methodDetail)) {
                    out.println(methodDetail);
                }
                if ((alternateName1 = method.getAnnotation(AlternateName.class)) == null) continue;
                out.println(Builders.detailMethod(method, alternateName1.value()));
            }
            out.println("            </BuildParameters>");
            out.println("        </Element>-->");
            out.println();
        }
        out.println("    </Elements>");
        out.println("</PipelineOptions>");
    }

    private static String detailMethod(Method method) {
        return Builders.detailMethod(method, method.getName().substring(3));
    }

    private static String detailMethod(Method method, String name) {
        Deprecated deprecated = method.getAnnotation(Deprecated.class);
        if (!Builders.checkParameterDetails(method) || Objects.nonNull(deprecated)) {
            logger.debug("Skipping " + name);
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("             <").append(name).append(">");
        if (method.getName().equals("build")) {
            builder.append("No default, value must be supplied");
        } else {
            builder.append(Builders.getDefaultValue(method));
        }
        builder.append(" - see ").append(method.getDeclaringClass().getName()).append("#").append(method.getName());
        builder.append("(");
        builder.append(Builders.getParameterDetails(method));
        builder.append(")");
        builder.append("</").append(name).append(">");
        if (methodsSeen.contains(builder.toString())) {
            logger.debug("already seen {}", (Object)builder.toString());
            return "";
        }
        methodsSeen.add(builder.toString());
        return builder.toString();
    }

    private static String getParameterDetails(Method method) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter parameter = method.getParameters()[i];
            String parameterType = parameter.getType().getName();
            if (parameterType.equals("[B")) {
                builder.append("byte[]");
            } else if (parameterType.startsWith("[L")) {
                builder.append(parameterType.substring(2, parameterType.length() - 1)).append("[]");
            } else {
                builder.append(parameterType);
            }
            if (i == method.getParameterCount() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private static boolean checkParameterDetails(Method method) {
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter parameter = method.getParameters()[i];
            String parameterType = parameter.getType().getName();
            if (parameterType.equals("[B")) {
                return false;
            }
            if (parameterType.startsWith("[L")) {
                return false;
            }
            if (parameterType.startsWith("fiftyone")) {
                return false;
            }
            if (!parameterType.startsWith("java.util")) continue;
            return false;
        }
        return true;
    }

    private static String getDefaultValue(Method method) {
        DefaultValue defaultValue = method.getAnnotation(DefaultValue.class);
        if (Objects.nonNull(defaultValue)) {
            if (Check.notNullOrBlank(defaultValue.value())) {
                return defaultValue.value();
            }
            if (defaultValue.intValue() != Integer.MIN_VALUE) {
                return String.valueOf(defaultValue.intValue());
            }
            if (defaultValue.doubleValue() != Double.MIN_VALUE) {
                return String.valueOf(defaultValue.doubleValue());
            }
            return String.valueOf(defaultValue.booleanValue());
        }
        return "";
    }
}

