/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.util;

import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;

public class Check {
    public static void guard(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T getNotNull(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static boolean notNullOrBlank(String arg) {
        return Objects.nonNull(arg) && BooleanUtils.isFalse((Boolean)arg.trim().isEmpty());
    }

    public static boolean isNullOrBlank(String arg) {
        return Objects.isNull(arg) || arg.trim().isEmpty();
    }

    public static boolean fileExists(String pathString) {
        if (Check.isNullOrBlank(pathString)) {
            return false;
        }
        return Paths.get(pathString, new String[0]).toFile().exists();
    }

    public static boolean notFileExists(String pathString) {
        return !Check.fileExists(pathString);
    }
}

