/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.util;

import fiftyone.pipeline.util.FileFinder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;

public class FiftyOneLookup {
    private static final Map<String, StringLookup> customLookups = new HashMap<String, StringLookup>();
    public static StringLookup FIFTYONE_LOOKUP;

    public static StringSubstitutor getSubstitutor() {
        return new FiftyOneStringSubstitutor(FIFTYONE_LOOKUP);
    }

    static {
        customLookups.put("envsys", new EnvSysLookup());
        customLookups.put("filepath", new FilePathLookup());
        FIFTYONE_LOOKUP = StringLookupFactory.INSTANCE.interpolatorStringLookup(customLookups, null, true);
    }

    public static class FiftyOneStringSubstitutor
    extends StringSubstitutor {
        public FiftyOneStringSubstitutor(StringLookup variableResolver) {
            super(variableResolver);
            this.setEnableSubstitutionInVariables(true);
        }

        protected String resolveVariable(String variableName, TextStringBuilder buf, int startPos, int endPos) {
            if (variableName.contains(":")) {
                return super.resolveVariable(variableName, buf, startPos, endPos);
            }
            return super.resolveVariable("envsys:" + variableName, buf, startPos, endPos);
        }
    }

    static class EnvSysLookup
    implements StringLookup {
        EnvSysLookup() {
        }

        public String lookup(String key) {
            String val = System.getenv(key);
            if (val == null && (val = System.getenv(key.toUpperCase(Locale.ROOT))) == null) {
                val = System.getProperty(key);
            }
            return val;
        }
    }

    static class FilePathLookup
    implements StringLookup {
        FilePathLookup() {
        }

        public String lookup(String key) {
            try {
                return FileFinder.getFilePath(key).getAbsolutePath();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

