/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class FileFinder {
    public static int DEPTH_TO_SEARCH = 30;

    public static File getFilePath(String file, String searchRoot) {
        try {
            Optional<Path> p = Files.find(Paths.get(searchRoot, new String[0]), DEPTH_TO_SEARCH, (path, a) -> path.endsWith(file), new FileVisitOption[0]).findFirst();
            if (p.isPresent()) {
                return p.get().toFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Cannot find " + file + " in " + searchRoot);
    }

    public static File getFilePath(String file) {
        String searchRoot = Objects.isNull(System.getProperty("project.root")) ? System.getProperty("user.dir") : System.getProperty("project.root");
        return FileFinder.getFilePath(file, searchRoot);
    }
}

