/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.data;

import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EvidenceKeyFilterShareUsage
implements EvidenceKeyFilter {
    private final boolean includeSession;
    private final String sessionCookieName;
    private final Set<String> blockedHttpHeaders = new HashSet<String>();
    private final Set<String> includedQueryStringParams = new HashSet<String>();

    public EvidenceKeyFilterShareUsage(List<String> blockedHttpHeaders, List<String> includedQueryStringParams, boolean includeSession, String sessionCookieName) {
        this.blockedHttpHeaders.add("cookies");
        this.includeSession = includeSession;
        this.sessionCookieName = sessionCookieName;
        for (String header : blockedHttpHeaders) {
            String lowerHeader = header.toLowerCase();
            if (this.blockedHttpHeaders.contains(lowerHeader)) continue;
            this.blockedHttpHeaders.add(lowerHeader);
        }
        for (String parameter : includedQueryStringParams) {
            String lowerParameter = parameter.toLowerCase();
            if (this.includedQueryStringParams.contains(lowerParameter)) continue;
            this.includedQueryStringParams.add(lowerParameter);
        }
    }

    public boolean include(String key) {
        boolean result;
        String[] parts = key.toLowerCase().split("\\.");
        if (parts.length == 2) {
            switch (parts[0]) {
                case "header": {
                    result = !this.blockedHttpHeaders.contains(parts[1]);
                    break;
                }
                case "cookie": {
                    result = parts[1].startsWith("51d_") || this.includeSession && parts[1].equals(this.sessionCookieName);
                    break;
                }
                case "session": {
                    result = parts[1].startsWith("51d_");
                    break;
                }
                case "query": {
                    result = this.includedQueryStringParams.contains(parts[1]);
                    break;
                }
                default: {
                    result = true;
                    break;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public Integer order(String key) {
        return 100;
    }
}

