/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.engines.fiftyone.flowelements.SequenceElement;
import fiftyone.pipeline.engines.fiftyone.flowelements.SequenceElementBuilder;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageBuilder;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageElement;
import org.slf4j.ILoggerFactory;

public class FiftyOnePipelineBuilder
extends PipelineBuilder {
    private boolean shareUsageEnabled = true;

    public FiftyOnePipelineBuilder() {
    }

    public FiftyOnePipelineBuilder(ILoggerFactory loggerFactory) {
        super(loggerFactory);
    }

    public FiftyOnePipelineBuilder setShareUsage(boolean enabled) {
        this.shareUsageEnabled = enabled;
        return this;
    }

    protected void onPreBuild() {
        boolean containsSequence = false;
        for (Object element : this.getFlowElements()) {
            if (!(element instanceof SequenceElement)) continue;
            containsSequence = true;
            break;
        }
        if (!containsSequence) {
            try {
                this.flowElements.add(0, new SequenceElementBuilder(this.loggerFactory).build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.shareUsageEnabled) {
            boolean containsShareUsage = false;
            for (FlowElement element : this.getFlowElements()) {
                if (!(element instanceof ShareUsageElement)) continue;
                containsShareUsage = true;
                break;
            }
            if (!containsShareUsage) {
                try {
                    this.addFlowElement((FlowElement)new ShareUsageBuilder(this.loggerFactory).build());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

