/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;

public class SequenceElement
extends FlowElementBase<ElementData, ElementPropertyMetaData> {
    public SequenceElement(Logger logger) {
        super(logger, null);
    }

    protected void processInternal(FlowData data) throws Exception {
        Map evidence = data.getEvidence().asKeyMap();
        if (!evidence.containsKey("query.session-id")) {
            data.addEvidence("query.session-id", (Object)this.getNewSessionId());
        }
        if (!evidence.containsKey("query.sequence")) {
            data.addEvidence("query.sequence", (Object)1);
        } else {
            Object sequence = evidence.get("query.sequence");
            int seq = (Integer)sequence;
            data.addEvidence("query.sequence", (Object)(seq + 1));
        }
    }

    public String getElementDataKey() {
        return "sequence-element";
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return new EvidenceKeyFilterWhitelist(new ArrayList());
    }

    public List<ElementPropertyMetaData> getProperties() {
        return new ArrayList<ElementPropertyMetaData>();
    }

    protected void managedResourcesCleanup() {
    }

    protected void unmanagedResourcesCleanup() {
    }

    private String getNewSessionId() {
        UUID u = UUID.randomUUID();
        return u.toString();
    }
}

