/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.caching.CacheBuilder;
import fiftyone.caching.LruPutCache;
import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.Evidence;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.fiftyone.data.EvidenceKeyFilterShareUsage;
import fiftyone.pipeline.engines.fiftyone.exceptions.HttpException;
import fiftyone.pipeline.engines.fiftyone.trackers.ShareUsageTracker;
import fiftyone.pipeline.engines.trackers.Tracker;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class ShareUsageBase
extends FlowElementBase<ElementData, ElementPropertyMetaData> {
    private static final InetAddress[] localHosts;
    protected static final SimpleDateFormat DATE_FMT;
    static final Marker threadMarker;
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();
    protected BlockingQueue<ShareUsageData> evidenceCollection;
    protected int takeTimeout;
    protected final int minEntriesPerMessage;
    protected final String shareUsageUrl;
    private final EvidenceKeyFilter evidenceKeyFilter;
    private final EvidenceKeyFilter evidenceKeyFilterExclSession;
    private final List<Map.Entry<String, String>> ignoreDataEvidenceFilter;
    private String hostAddress;
    private List<ElementPropertyMetaData> properties;
    private volatile Future<?> sendDataFuture = null;
    private final Object lock = new Object();
    private final int addTimeout;
    private final Random random = new Random();
    private Tracker tracker;
    private final long intervalMillis;
    private double sharePercentage = 1.0;
    private List<String> flowElements = null;
    protected final String osVersion;
    protected final String languageVersion;
    protected final String coreVersion;
    private String enginesVersion;
    private boolean canceled = false;
    protected long lostData;
    protected long lostDataReset = 5000000L;

    protected ShareUsageBase(Logger logger, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter) {
        this(logger, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, "JSESSIONID");
    }

    protected ShareUsageBase(Logger logger, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter, String sessionCookieName) {
        this(logger, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, sessionCookieName, null);
    }

    protected ShareUsageBase(Logger logger, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter, String sessionCookieName, Tracker tracker) {
        super(logger, null);
        if (minimumEntriesPerMessage > maximumQueueSize) {
            throw new IllegalArgumentException("The minimum entries per message cannot be larger than the maximum size of the queue.");
        }
        if (!blockedHttpHeaders.contains("cookie")) {
            blockedHttpHeaders.add("cookie");
        }
        this.evidenceCollection = new LinkedBlockingQueue<ShareUsageData>(maximumQueueSize);
        this.addTimeout = addTimeout;
        this.takeTimeout = takeTimeout;
        this.sharePercentage = sharePercentage;
        this.minEntriesPerMessage = minimumEntriesPerMessage;
        this.intervalMillis = (long)repeatEvidenceIntervalMinutes * 60L * 1000L;
        this.shareUsageUrl = shareUsageUrl;
        this.languageVersion = System.getProperty("java.version");
        this.osVersion = System.getProperty("os.name");
        this.setEnginesVersion(((Object)((Object)this)).getClass().getPackage().getImplementationVersion());
        this.coreVersion = Pipeline.class.getPackage().getImplementationVersion();
        includedQueryStringParameters.add("session-id");
        includedQueryStringParameters.add("sequence");
        this.evidenceKeyFilter = new EvidenceKeyFilterShareUsage(blockedHttpHeaders, includedQueryStringParameters, true, sessionCookieName);
        this.evidenceKeyFilterExclSession = new EvidenceKeyFilterShareUsage(blockedHttpHeaders, includedQueryStringParameters, false, sessionCookieName);
        this.ignoreDataEvidenceFilter = ignoreDataEvidenceFilter;
        this.tracker = tracker;
        if (tracker == null) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration((CacheBuilder)new LruPutCache.Builder(), 1000);
            this.tracker = new ShareUsageTracker(cacheConfiguration, this.intervalMillis, new EvidenceKeyFilterShareUsage(blockedHttpHeaders, includedQueryStringParameters, trackSession, sessionCookieName));
        }
        this.properties = new ArrayList<ElementPropertyMetaData>();
    }

    protected List<String> getFlowElements() {
        if (this.flowElements == null) {
            if (this.getPipelines().size() == 1) {
                Pipeline pipeline = (Pipeline)this.getPipelines().get(0);
                ArrayList<String> list = new ArrayList<String>();
                for (FlowElement element : pipeline.getFlowElements()) {
                    list.add(element.getClass().getSimpleName());
                }
                this.flowElements = list;
            } else {
                this.logger.warn("Share usage element registered to " + (this.getPipelines().size() > 0 ? "too many" : "no") + " pipelines. Unable to send share usage information.");
                this.flowElements = new ArrayList<String>();
            }
        }
        return this.flowElements;
    }

    public String getElementDataKey() {
        return "shareusage";
    }

    protected String getHostAddress() {
        if (this.hostAddress == null) {
            String address = null;
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                address = socket.getLocalAddress().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.logger.debug("The host was unknown", (Throwable)e);
            }
            catch (SocketException e) {
                this.logger.debug("There was a socket exception", (Throwable)e);
            }
            this.hostAddress = address == null ? "" : address;
        }
        return this.hostAddress;
    }

    public void addPipeline(Pipeline pipeline) {
        if (this.getPipelines().size() > 0) {
            throw new RuntimeException("Cannot add ShareUsageElement to multiple pipelines.");
        }
        super.addPipeline(pipeline);
    }

    protected void processInternal(FlowData flowData) {
        boolean ignoreData = false;
        Map evidence = flowData.getEvidence().asKeyMap();
        this.logger.debug("processInternal()");
        if (this.ignoreDataEvidenceFilter != null) {
            for (Map.Entry<String, String> entry : this.ignoreDataEvidenceFilter) {
                String key = entry.getKey();
                if (!evidence.containsKey(key) || !evidence.get(key).toString().equals(entry.getValue())) continue;
                ignoreData = true;
                break;
            }
        }
        if (!this.isCanceled() && !ignoreData) {
            this.processData(flowData);
        }
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return this.evidenceKeyFilter;
    }

    public List<ElementPropertyMetaData> getProperties() {
        return this.properties;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    protected void cancel() {
        this.logger.warn("UsageData sending has been cancelled");
        this.canceled = true;
    }

    boolean isRunning() {
        return this.sendDataFuture != null && !this.sendDataFuture.isDone() && !this.sendDataFuture.isCancelled();
    }

    Future<?> getSendDataFuture() {
        return this.sendDataFuture;
    }

    public FlowElement.DataFactory<ElementData> getDataFactory() {
        return null;
    }

    protected void managedResourcesCleanup() {
        this.trySendData();
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                this.logger.warn("Could not send final data on close down");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while awaiting close down");
        }
    }

    protected void unmanagedResourcesCleanup() {
    }

    private boolean isLocalHost(String address) throws UnknownHostException {
        InetAddress other = InetAddress.getByName(address);
        for (InetAddress host : localHosts) {
            if (!host.equals(other)) continue;
            return true;
        }
        return false;
    }

    private void processData(FlowData data) {
        this.logger.debug("processData()");
        if (this.random.nextDouble() <= this.sharePercentage && this.tracker.track(data)) {
            try {
                if (this.evidenceCollection.offer(this.getDataFromEvidence(data.getEvidence()), this.addTimeout, TimeUnit.MILLISECONDS)) {
                    this.logger.debug("Queued {} entries", (Object)this.evidenceCollection.size());
                    if (this.evidenceCollection.size() >= this.minEntriesPerMessage) {
                        this.trySendData();
                    }
                } else if (++this.lostData >= this.lostDataReset) {
                    this.logger.warn("Could not queue data for Share Usage. This could mean that the queue is too small, that the proportion of data shared is too high - or that the sending process has encountered problems sending.");
                    this.lostData = 0L;
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("interrupted Exception while enqueueing ShareUsage data.");
            }
        }
    }

    private ShareUsageData getDataFromEvidence(Evidence evidence) {
        ShareUsageData shareUsageData = new ShareUsageData();
        block12: for (Map.Entry entry : evidence.asKeyMap().entrySet()) {
            if (!this.evidenceKeyFilterExclSession.include((String)entry.getKey())) continue;
            switch ((String)entry.getKey()) {
                case "server.client-ip": {
                    shareUsageData.clientIP = entry.getValue().toString();
                    continue block12;
                }
                case "query.session-id": {
                    shareUsageData.sessionId = entry.getValue().toString();
                    continue block12;
                }
                case "query.sequence": {
                    try {
                        int sequence;
                        shareUsageData.sequence = sequence = Integer.parseInt(entry.getValue().toString(), 10);
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("The value '{}' could not be parsed to an integer.", entry.getValue());
                    }
                    continue block12;
                }
            }
            shareUsageData.tryAddToData((String)entry.getKey(), entry.getValue());
        }
        return shareUsageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trySendData() {
        this.logger.debug("trySendData");
        if (!this.isCanceled() && !this.isRunning()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isRunning()) {
                    this.logger.debug(threadMarker, "starting runnable");
                    this.sendDataFuture = this.executor.submit(() -> {
                        this.logger.debug(threadMarker, "runnable is running");
                        try {
                            this.sendUsageData();
                            this.logger.debug(threadMarker, "Done sending");
                        }
                        catch (Exception e) {
                            this.logger.error("Share usage encountered an error.", (Throwable)e);
                        }
                    });
                }
            }
        }
    }

    protected abstract void sendUsageData() throws HttpException;

    public String getEnginesVersion() {
        return this.enginesVersion;
    }

    public void setEnginesVersion(String enginesVersion) {
        this.enginesVersion = enginesVersion;
    }

    static {
        InetAddress[] localHosts1;
        DATE_FMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            localHosts1 = new InetAddress[]{InetAddress.getByName("127.0.0.1"), InetAddress.getByName("::1")};
        }
        catch (UnknownHostException e) {
            localHosts1 = new InetAddress[]{};
        }
        localHosts = localHosts1;
        threadMarker = MarkerFactory.getMarker((String)"Sending");
    }

    protected static class ShareUsageData {
        public String sessionId;
        public int sequence;
        public String clientIP;
        public final Map<String, Map<String, String>> evidenceData = new HashMap<String, Map<String, String>>();

        protected ShareUsageData() {
        }

        void tryAddToData(String key, Object value) {
            Map<String, String> categoryDict;
            String category = "";
            String field = key;
            int firstSeparator = key.indexOf(".");
            if (firstSeparator > 0) {
                category = key.substring(0, firstSeparator);
                field = key.substring(firstSeparator + 1);
            }
            if (Objects.isNull(categoryDict = this.evidenceData.get(category))) {
                categoryDict = new HashMap<String, String>();
                this.evidenceData.put(category, categoryDict);
            }
            categoryDict.put(field, value.toString());
        }
    }
}

