/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageBase;
import fiftyone.pipeline.util.Check;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public abstract class ShareUsageBuilderBase<T extends ShareUsageBase> {
    protected final ILoggerFactory loggerFactory;
    protected final Logger logger;
    protected int repeatEvidenceInterval = 20;
    protected double sharePercentage = 1.0;
    protected int minimumEntriesPerMessage = 50;
    protected int maximumQueueSize = 1000;
    protected int addTimeout = 0;
    protected int takeTimeout = 0;
    protected String shareUsageUrl = "https://devices-v4.51degrees.com/new.ashx";
    protected String sessionCookieName = "JSESSIONID";
    protected List<String> blockedHttpHeaders = new ArrayList<String>();
    protected final List<String> includedQueryStringParameters = new ArrayList<String>();
    protected final List<Map.Entry<String, String>> ignoreDataEvidenceFilter = new ArrayList<Map.Entry<String, String>>();
    protected boolean trackSession;

    public ShareUsageBuilderBase(ILoggerFactory loggerFactory) {
        this(loggerFactory, loggerFactory.getLogger(ShareUsageBuilderBase.class.getName()));
    }

    public ShareUsageBuilderBase(ILoggerFactory loggerFactory, Logger logger) {
        this.logger = logger;
        this.loggerFactory = loggerFactory;
    }

    @DefaultValue(value="No sharing")
    public ShareUsageBuilderBase<T> setIncludedQueryStringParameters(List<String> queryStringParameterNames) {
        this.includedQueryStringParameters.clear();
        this.includedQueryStringParameters.addAll(queryStringParameterNames);
        return this;
    }

    @DefaultValue(value="No sharing")
    public ShareUsageBuilderBase<T> setIncludedQueryStringParameters(String queryStringParameterNames) {
        this.includedQueryStringParameters.clear();
        this.includedQueryStringParameters.addAll(Arrays.asList(queryStringParameterNames.split("\\s*,\\s*")));
        return this;
    }

    @DefaultValue(value="No sharing")
    public ShareUsageBuilderBase<T> setIncludedQueryStringParameter(String queryStringParameterName) {
        this.includedQueryStringParameters.add(queryStringParameterName.trim());
        return this;
    }

    @DefaultValue(value="All HTTP Headers are shared except cookies that do not start with 51D_")
    public ShareUsageBuilderBase<T> setBlockedHttpHeaders(List<String> blockedHeaders) {
        this.blockedHttpHeaders = blockedHeaders;
        return this;
    }

    @DefaultValue(value="All HTTP Headers are shared except cookies that do not start with 51D_")
    public ShareUsageBuilderBase<T> setBlockedHttpHeaders(String blockedHeaders) {
        this.blockedHttpHeaders.addAll(Arrays.asList(blockedHeaders.split("\\s*,\\s*")));
        return this;
    }

    @DefaultValue(value="All HTTP Headers are shared except cookies that do not start with 51D_")
    public ShareUsageBuilderBase<T> setBlockedHttpHeader(String blockedHeader) {
        this.blockedHttpHeaders.add(blockedHeader.trim());
        return this;
    }

    @DefaultValue(value="All values are shared")
    public ShareUsageBuilderBase<T> setIgnoreFlowDataEvidenceFilter(String evidenceFilter) {
        if (Check.isNullOrBlank((String)evidenceFilter)) {
            throw new IllegalArgumentException("Evidence filter must be non-null");
        }
        for (String entryString : evidenceFilter.split(",")) {
            String[] split = entryString.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Evidence filter must be of the form key:value[,key:value] but was \"" + evidenceFilter + "\"");
            }
            this.ignoreDataEvidenceFilter.add(new AbstractMap.SimpleEntry<String, String>(split[0].trim(), split[1].trim()));
        }
        return this;
    }

    @DefaultValue(doubleValue=1.0)
    public ShareUsageBuilderBase<T> setSharePercentage(double sharePercentage) {
        if (sharePercentage < 0.0 || sharePercentage > 1.0) {
            throw new IllegalArgumentException("Share percentage must be between 0 and 1 (" + sharePercentage + ")");
        }
        this.sharePercentage = sharePercentage;
        return this;
    }

    @DefaultValue(intValue=50)
    public ShareUsageBuilderBase<T> setMinimumEntriesPerMessage(int minimumEntriesPerMessage) {
        if (minimumEntriesPerMessage <= 0) {
            throw new IllegalArgumentException("Minimum entries per message must be greater than 0");
        }
        this.minimumEntriesPerMessage = minimumEntriesPerMessage;
        return this;
    }

    @DefaultValue(intValue=1000)
    public ShareUsageBuilderBase<T> setMaximumQueueSize(int size) {
        if (size <= this.minimumEntriesPerMessage) {
            throw new IllegalArgumentException("Maximum queue size must be greater than the minimum entries per message, trying to set " + size + " but minimum is " + this.minimumEntriesPerMessage);
        }
        this.maximumQueueSize = size;
        return this;
    }

    public int getMaximumQueueSize() {
        return this.maximumQueueSize;
    }

    @Deprecated
    public ShareUsageBuilderBase<T> setAddTimeout(int milliseconds) {
        this.addTimeout = milliseconds;
        return this;
    }

    @DefaultValue(intValue=0)
    public ShareUsageBuilderBase<T> setAddTimeoutMillis(int milliseconds) {
        if (milliseconds < 0) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.addTimeout = milliseconds;
        return this;
    }

    @Deprecated
    public ShareUsageBuilderBase<T> setTakeTimeout(int milliseconds) {
        this.takeTimeout = milliseconds;
        return this;
    }

    @DefaultValue(intValue=0)
    public ShareUsageBuilderBase<T> setTakeTimeoutMillis(int milliseconds) {
        if (milliseconds < 0) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.takeTimeout = milliseconds;
        return this;
    }

    @DefaultValue(value="Send to 51D - https://devices-v4.51degrees.com/new.ashx")
    public ShareUsageBuilderBase<T> setShareUsageUrl(String shareUsageUrl) {
        try {
            URL url = new URL(shareUsageUrl);
            assert (!url.toString().isEmpty());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.shareUsageUrl = shareUsageUrl;
        return this;
    }

    @DefaultValue(value="JSESSIONID")
    public ShareUsageBuilderBase<T> setSessionCookieName(String cookieName) {
        HttpCookie cookie = new HttpCookie(cookieName, "test");
        assert (!cookie.getName().isEmpty());
        this.sessionCookieName = cookieName;
        return this;
    }

    @DefaultValue(intValue=20)
    public ShareUsageBuilderBase<T> setRepeatEvidenceIntervalMinutes(int interval) {
        this.repeatEvidenceInterval = interval;
        return this;
    }

    @DefaultValue(value="false")
    public ShareUsageBuilderBase<T> setTrackSession(boolean track) {
        this.trackSession = track;
        return this;
    }

    public abstract T build() throws IOException;
}

