/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.data;

import fiftyone.pipeline.core.data.ElementDataBase;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.FlowError;
import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.data.ProcessCallable;
import fiftyone.pipeline.engines.exceptions.LazyLoadTimeoutException;
import fiftyone.pipeline.engines.exceptions.PropertyMissingException;
import fiftyone.pipeline.engines.flowelements.AspectEngine;
import fiftyone.pipeline.engines.services.MissingPropertyResult;
import fiftyone.pipeline.engines.services.MissingPropertyService;
import fiftyone.pipeline.exceptions.AggregateException;
import fiftyone.pipeline.util.Check;
import fiftyone.pipeline.util.StringManipulation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AspectDataBase
extends ElementDataBase
implements AspectData {
    private final MissingPropertyService missingPropertyService;
    private final List<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>> engines = new ArrayList<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>>();
    private final Map<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>, Future<?>> processFutures;

    public AspectDataBase(Logger logger, FlowData flowData, AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine) {
        this(logger, flowData, engine, null);
    }

    public AspectDataBase(Logger logger, FlowData flowData, AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine, MissingPropertyService missingPropertyService) {
        super(logger, flowData);
        this.engines.add((AspectEngine)Check.getNotNull(engine, (String)"Engine must not be null"));
        this.processFutures = new HashMap();
        this.missingPropertyService = missingPropertyService;
    }

    public AspectDataBase(Logger logger, FlowData flowData, AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine, MissingPropertyService missingPropertyService, Map<String, Object> map) {
        super(logger, flowData, map);
        this.engines.add((AspectEngine)Check.getNotNull(engine, (String)"Engine must not be null"));
        this.processFutures = new HashMap();
        this.missingPropertyService = missingPropertyService;
    }

    @Override
    public List<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>> getEngines() {
        return Collections.unmodifiableList(this.engines);
    }

    @Override
    public Future<?> getProcessFuture() {
        return new Future<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = true;
                for (Future future : AspectDataBase.this.processFutures.values()) {
                    result = future.cancel(mayInterruptIfRunning) && result;
                }
                return result;
            }

            @Override
            public boolean isCancelled() {
                for (Future future : AspectDataBase.this.processFutures.values()) {
                    if (!future.isCancelled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                for (Future future : AspectDataBase.this.processFutures.values()) {
                    if (future.isDone()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                for (Future future : AspectDataBase.this.processFutures.values()) {
                    future.get();
                }
                return null;
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : AspectDataBase.this.processFutures.values()) {
                    future.get(timeout, unit);
                }
                return null;
            }
        };
    }

    public void addEngine(AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine) {
        this.engines.add(engine);
    }

    public void addProcessCallable(ProcessCallable runnable) {
        Future<Void> future = runnable.engine.getExecutor().submit(runnable);
        this.processFutures.put(runnable.engine, future);
    }

    public Map<String, Object> asKeyMap() {
        this.waitOnAllProcessFutures();
        return super.asKeyMap();
    }

    public Object get(String propertyName) throws PropertyMissingException {
        return this.getAs(propertyName, Object.class, new Class[0]);
    }

    protected <T> T getAs(String key, Class<T> type, Class<?> ... parameterisedTypes) {
        TryGetResult<T> result;
        List<FlowError> errors;
        Check.getNotNull((Object)key, (String)"Key cannot be null.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AspectData '" + this.getClass().getSimpleName() + "'-'" + this.hashCode() + "' property value requested for key '" + key + "'.");
        }
        if (!AspectDataBase.anyLazyLoaded(this.engines) || (errors = this.waitOnAllProcessFutures()).size() == 0) {
            result = this.tryGetValue(key, type, parameterisedTypes);
            if (!result.hasValue() && this.missingPropertyService != null) {
                MissingPropertyResult missingReason = this.missingPropertyService.getMissingPropertyReason(key, this.engines);
                this.logger.debug("Property '" + key + "' missing from aspect data '" + this.getClass().getName() + "'-'" + this.hashCode() + "'. " + (Object)((Object)missingReason.getReason()));
                throw new PropertyMissingException(missingReason.getReason(), key, missingReason.getDescription());
            }
        } else {
            if (errors.size() == 1) {
                Throwable e = errors.get(0).getThrowable();
                if (e instanceof CancellationException) {
                    throw (CancellationException)e;
                }
                if (e instanceof TimeoutException) {
                    throw new LazyLoadTimeoutException("Failed to retrieve property '" + key + "' because the processing for engine(s) " + StringManipulation.stringJoin(this.getDistinctEngineNames(), (String)", ") + " took longer than the specified timeout.", e);
                }
                throw new RuntimeException("Failed to retrieve property '" + key + "' because processing threw an exception in engine(s) " + StringManipulation.stringJoin(this.getDistinctEngineNames(), (String)", ") + ".", e);
            }
            throw new AggregateException("Failed to retrieve property '" + key + "' because processing threw multiple exceptions in engine(s) " + StringManipulation.stringJoin(this.getDistinctEngineNames(), (String)", ") + ".", (Collection)errors.stream().map(FlowError::getThrowable).collect(Collectors.toList()));
        }
        return (T)result.getValue();
    }

    protected <T> TryGetResult<T> tryGetValue(String key, Class<T> type, Class<?> ... parameterisedTypes) {
        TryGetResult result = new TryGetResult();
        Map<String, Object> map = this.asKeyMap();
        if (map.containsKey(key)) {
            Object obj = this.asKeyMap().get(key);
            try {
                T value = type.cast(obj);
                result.setValue(value);
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Expected property '" + key + "' to be of type '" + type.getSimpleName() + "' but it is '" + obj.getClass().getSimpleName() + "'");
            }
        }
        return result;
    }

    private static boolean anyLazyLoaded(List<AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData>> engines2) {
        for (AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine : engines2) {
            if (engine.getLazyLoadingConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    private List<FlowError> waitOnAllProcessFutures() {
        ArrayList<FlowError> errors = new ArrayList<FlowError>();
        for (Map.Entry<AspectEngine<AspectData, AspectPropertyMetaData>, Future<?>> entry : this.processFutures.entrySet()) {
            try {
                entry.getValue().get(entry.getKey().getLazyLoadingConfiguration().getPropertyTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                errors.add((FlowError)new FlowError.Default((Throwable)e, (FlowElement)entry.getKey()));
            }
        }
        return errors;
    }

    private List<String> getDistinctEngineNames() {
        ArrayList<String> strings = new ArrayList<String>();
        for (AspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine : this.processFutures.keySet()) {
            if (strings.contains(engine.getClass().getName())) continue;
            strings.add(engine.getClass().getName());
        }
        return strings;
    }
}

