/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.data;

import fiftyone.pipeline.engines.configuration.DataFileConfiguration;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.data.AspectEngineDataFile;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.engines.services.DataUpdateService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;

public class AspectEngineDataFileDefault
implements AspectEngineDataFile {
    private String identifier;
    private OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine;
    private DataFileConfiguration configuration;
    private DataUpdateService dataUpdateService = null;
    private String tempDataDirPath;
    private String tempDataFilePath;
    private Date updateAvailableTime;
    private Date dataPublishedTime;
    private long lastUpdateFileCreateTime;
    private final Object syncLock = new Object();
    private ScheduledFuture<?> future;
    private ScheduledFuture<?> pollFuture;
    private boolean disposedValue = false;

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(OnPremiseAspectEngine<? extends AspectData, ? extends AspectPropertyMetaData> engine) {
        this.engine = engine;
    }

    @Override
    public String getDataFilePath() {
        return this.configuration.getDataFilePath();
    }

    @Override
    public String getTempDataFilePath() {
        if (this.tempDataFilePath == null && this.getTempDataDirPath() != null && this.getDataFilePath() != null) {
            this.tempDataFilePath = Paths.get(this.getTempDataDirPath(), new File(this.getDataFilePath()).getName()).toString();
        }
        return this.tempDataFilePath;
    }

    @Override
    public void setTempDataFilePath(String path) {
        this.tempDataFilePath = path;
    }

    @Override
    public String getTempDataDirPath() {
        if (this.tempDataDirPath == null && this.engine != null && this.engine.getTempDataDirPath() != null) {
            this.tempDataDirPath = this.engine.getTempDataDirPath();
        }
        return this.tempDataDirPath;
    }

    @Override
    public void setTempDataDirPath(String path) {
        this.tempDataDirPath = path;
    }

    @Override
    public boolean getAutomaticUpdatesEnabled() {
        return this.configuration.getAutomaticUpdatesEnabled();
    }

    @Override
    public Date getUpdateAvailableTime() {
        return this.updateAvailableTime;
    }

    @Override
    public void setUpdateAvailableTime(Date updateAvailableTime) {
        this.updateAvailableTime = updateAvailableTime;
    }

    @Override
    public Date getDataPublishedDateTime() {
        return this.dataPublishedTime == null ? new Date(0L) : this.dataPublishedTime;
    }

    @Override
    public void setDataPublishedDateTime(Date dataPublishedTime) {
        this.dataPublishedTime = dataPublishedTime;
    }

    @Override
    public DataFileConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(DataFileConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean getIsRegistered() {
        return this.dataUpdateService != null;
    }

    @Override
    public String getFormattedUrl() {
        if (this.configuration.getUrlFormatter() == null) {
            return this.configuration.getDataUpdateUrl();
        }
        return this.configuration.getUrlFormatter().getFormattedDataUpdateUrl(this);
    }

    @Override
    public void setDataUpdateService(DataUpdateService dataUpdateService) {
        this.dataUpdateService = dataUpdateService;
    }

    public long getLastUpdateFileCreateTime() {
        return this.lastUpdateFileCreateTime;
    }

    public void setLastUpdateFileCreateTime(long createTime) {
        this.lastUpdateFileCreateTime = createTime;
    }

    public Object getUpdateSyncLock() {
        return this.syncLock;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public ScheduledFuture<?> getPollFuture() {
        return this.pollFuture;
    }

    public void setPollFuture(ScheduledFuture<?> future) {
        this.pollFuture = future;
    }

    @Override
    public void close() throws IOException {
        if (!this.disposedValue) {
            if (this.dataUpdateService != null) {
                this.dataUpdateService.unregisterDataFile(this);
                this.dataUpdateService = null;
            }
            if (this.pollFuture != null) {
                this.pollFuture.cancel(true);
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.disposedValue = true;
        }
    }
}

