/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.data;

import fiftyone.pipeline.engines.data.DataLoader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONObject;

public class JsonLoader<T>
implements DataLoader<T> {
    private T loadData(Reader reader, Class<T> type) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        int bufferLength = 1024;
        char[] buffer = new char[bufferLength];
        StringBuilder builder = new StringBuilder();
        int read = reader.read(buffer, 0, bufferLength);
        while (read > 0) {
            builder.append(buffer, 0, read);
            read = reader.read(buffer, 0, bufferLength);
        }
        String json = builder.toString();
        JSONObject jsonObj = new JSONObject(json);
        T instance = type.newInstance();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String key : jsonObj.keySet()) {
            parameters.put(key.toLowerCase(), jsonObj.get(key));
        }
        for (Method method : type.getMethods()) {
            Object variable;
            if (!method.getName().startsWith("set")) continue;
            String variableName = method.getName().substring("set".length()).toLowerCase();
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1 || !parameters.containsKey(variableName) || !types[0].isAssignableFrom((variable = parameters.get(variableName)).getClass())) continue;
            method.invoke(instance, variable);
        }
        return instance;
    }

    @Override
    public T loadData(String filePath, Class<T> type) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try (FileReader reader = new FileReader(filePath);){
            T t = this.loadData(reader, type);
            return t;
        }
    }

    @Override
    public T loadData(byte[] data, Class<T> type) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            T t;
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                t = this.loadData(reader, type);
            }
            return t;
        }
    }
}

