/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.flowelements;

import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.engines.caching.FlowCacheDefault;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.configuration.LazyLoadingConfiguration;
import fiftyone.pipeline.engines.data.AspectPropertyMetaData;
import fiftyone.pipeline.engines.flowelements.AspectEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public abstract class AspectEngineBuilderBase<TBuilder extends AspectEngineBuilderBase<TBuilder, TEngine>, TEngine extends AspectEngine> {
    protected final ILoggerFactory loggerFactory;
    private final List<String> properties = new ArrayList<String>();
    protected CacheConfiguration cacheConfig = null;
    private LazyLoadingConfiguration lazyLoadingConfig = null;

    public AspectEngineBuilderBase() {
        this(LoggerFactory.getILoggerFactory());
    }

    public AspectEngineBuilderBase(ILoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    private void tryAddProperty(String property) {
        if (!this.properties.contains(property)) {
            this.properties.add(property);
        }
    }

    protected List<String> getProperties() {
        return this.properties;
    }

    public TBuilder setProperties(Set<AspectPropertyMetaData> set) {
        for (AspectPropertyMetaData property : set) {
            this.tryAddProperty(property.getName());
        }
        return (TBuilder)this;
    }

    @DefaultValue(value="All properties")
    public TBuilder setProperty(String s) {
        this.tryAddProperty(s);
        return (TBuilder)this;
    }

    public TBuilder setProperties(List<String> properties) {
        for (String property : properties) {
            this.tryAddProperty(property);
        }
        return (TBuilder)this;
    }

    @DefaultValue(value="All properties")
    public TBuilder setProperties(String properties) {
        for (String property : properties.split("\\s,\\s")) {
            this.tryAddProperty(property);
        }
        return (TBuilder)this;
    }

    public TBuilder setProperty(AspectPropertyMetaData aspectProperty) {
        this.tryAddProperty(aspectProperty.getName());
        return (TBuilder)this;
    }

    public TBuilder setLazyLoading(LazyLoadingConfiguration configuration) {
        this.lazyLoadingConfig = configuration;
        return (TBuilder)this;
    }

    public TBuilder setCache(CacheConfiguration cacheConfiguration) {
        this.cacheConfig = cacheConfiguration;
        return (TBuilder)this;
    }

    protected void configureEngine(TEngine engine) throws Exception {
        if (this.cacheConfig != null) {
            engine.setCache(new FlowCacheDefault(this.cacheConfig));
        }
        if (this.lazyLoadingConfig != null) {
            engine.setLazyLoading(this.lazyLoadingConfig);
        }
    }

    protected void preCreateEngine() {
    }

    protected abstract TEngine newEngine(List<String> var1) throws Exception;

    protected TEngine buildEngine() throws Exception {
        this.preCreateEngine();
        TEngine engine = this.newEngine(this.getProperties());
        this.configureEngine(engine);
        return engine;
    }
}

