/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.flowelements;

import fiftyone.pipeline.annotations.BuildArg;
import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.engines.configuration.DataFileConfiguration;
import fiftyone.pipeline.engines.configuration.DataFileConfigurationBuilder;
import fiftyone.pipeline.engines.data.DataUpdateUrlFormatter;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngine;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngineBuilderBase;
import fiftyone.pipeline.engines.services.DataUpdateService;
import org.slf4j.ILoggerFactory;

public abstract class SingleFileAspectEngineBuilderBase<TBuilder extends OnPremiseAspectEngineBuilderBase<TBuilder, TEngine>, TEngine extends OnPremiseAspectEngine>
extends OnPremiseAspectEngineBuilderBase<TBuilder, TEngine> {
    private final DataFileConfigurationBuilder dataFileBuilder = new DataFileConfigurationBuilder();

    public SingleFileAspectEngineBuilderBase() {
    }

    public SingleFileAspectEngineBuilderBase(ILoggerFactory loggerFactory) {
        super(loggerFactory);
    }

    public SingleFileAspectEngineBuilderBase(ILoggerFactory loggerFactory, DataUpdateService dataUpdateService) {
        super(loggerFactory, dataUpdateService);
    }

    public TEngine build(@BuildArg(value="dataFile") String dataFile, @BuildArg(value="createTempDataCopy") boolean createTempDataCopy) throws Exception {
        Object config = this.dataFileBuilder.build(dataFile, createTempDataCopy);
        this.addDataFile((DataFileConfiguration)config);
        return this.build();
    }

    public TEngine build(byte[] data) throws Exception {
        Object config = this.dataFileBuilder.build(data);
        this.addDataFile((DataFileConfiguration)config);
        return this.build();
    }

    protected TEngine build() throws Exception {
        if (this.dataFileConfigs.size() != 1) {
            throw new PipelineConfigurationException("This builder requires one and only one data file to be configured but " + this.dataFileConfigs.size() + " data file configurations that have been supplied.");
        }
        return (TEngine)((OnPremiseAspectEngine)this.buildEngine());
    }

    @DefaultValue(value="51Degrees default, set by subclass")
    public TBuilder setDataUpdateUrl(String url) {
        this.dataFileBuilder.setDataUpdateUrl(url);
        return (TBuilder)this;
    }

    @DefaultValue(value="51Degrees default, set by subclass")
    public TBuilder setDataUpdateUrlFormatter(DataUpdateUrlFormatter formatter) {
        this.dataFileBuilder.setDataUpdateUrlFormatter(formatter);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=true)
    public TBuilder setDataUpdateVerifyMd5(boolean verify) {
        this.dataFileBuilder.setDataUpdateVerifyMd5(verify);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=true)
    public TBuilder setDataUpdateDecompress(boolean decompress) {
        this.dataFileBuilder.setDataUpdateDecompress(decompress);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=true)
    public TBuilder setAutoUpdate(boolean enabled) {
        this.dataFileBuilder.setAutoUpdate(enabled);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=true)
    public TBuilder setDataFileSystemWatcher(boolean enabled) {
        this.dataFileBuilder.setDataFileSystemWatcher(enabled);
        return (TBuilder)this;
    }

    @Deprecated
    public TBuilder setUpdatePollingInterval(int pollingIntervalSeconds) {
        this.dataFileBuilder.setUpdatePollingInterval(pollingIntervalSeconds);
        return (TBuilder)this;
    }

    @DefaultValue(intValue=1800)
    public TBuilder setUpdatePollingIntervalSeconds(int pollingIntervalSeconds) {
        this.dataFileBuilder.setUpdatePollingInterval(pollingIntervalSeconds);
        return (TBuilder)this;
    }

    @Deprecated
    public TBuilder setUpdatePollingInterval(long pollingIntervalMillis) {
        this.dataFileBuilder.setUpdatePollingInterval(pollingIntervalMillis);
        return (TBuilder)this;
    }

    @DefaultValue(intValue=1800000)
    public TBuilder setUpdatePollingIntervalMillis(long pollingIntervalMillis) {
        this.dataFileBuilder.setUpdatePollingInterval(pollingIntervalMillis);
        return (TBuilder)this;
    }

    @Deprecated
    public TBuilder setUpdateRandomisationMax(long maximumDeviationMillis) {
        this.dataFileBuilder.setUpdateRandomisationMax(maximumDeviationMillis);
        return (TBuilder)this;
    }

    @DefaultValue(intValue=600)
    public TBuilder setUpdateRandomisationMaxMillis(long maximumDeviationMillis) {
        this.dataFileBuilder.setUpdateRandomisationMax(maximumDeviationMillis);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=true)
    public TBuilder setVerifyIfModifiedSince(boolean enabled) {
        this.dataFileBuilder.setVerifyIfModifiedSince(enabled);
        return (TBuilder)this;
    }

    @DefaultValue(value="No licence keys")
    public TBuilder setDataUpdateLicenseKey(String key) {
        this.dataFileBuilder.setDataUpdateLicenseKey(key);
        return (TBuilder)this;
    }

    @DefaultValue(value="No license keys")
    public TBuilder setDataUpdateLicenseKeys(String[] keys) {
        this.dataFileBuilder.setDataUpdateLicenseKeys(keys);
        return (TBuilder)this;
    }

    @DefaultValue(booleanValue=false)
    public TBuilder setDataUpdateOnStartup(boolean enabled) {
        this.dataFileBuilder.setUpdateOnStartup(enabled);
        return (TBuilder)this;
    }
}

