/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.jsonbuilder.flowelements;

import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaDataDefault;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.FlowError;
import fiftyone.pipeline.core.data.PropertyMatcher;
import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.data.types.JavaScript;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.exceptions.NoValueException;
import fiftyone.pipeline.jsonbuilder.Constants;
import fiftyone.pipeline.jsonbuilder.data.JsonBuilderData;
import fiftyone.pipeline.jsonbuilder.flowelements.JsPropertyMatcher;
import fiftyone.pipeline.jsonbuilder.flowelements.JsonBuilder;
import fiftyone.pipeline.jsonbuilder.flowelements.JsonBuilderDataInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import org.slf4j.Logger;

public class JsonBuilderElement
extends FlowElementBase<JsonBuilderData, ElementPropertyMetaData>
implements JsonBuilder {
    private static final String JAVASCRIPT_PROPERTIES_NAME = "javascriptProperties";
    private final EvidenceKeyFilter evidenceKeyFilter;
    private final List<ElementPropertyMetaData> properties;
    private final List<String> blacklist;
    private final Set<String> elementBlacklist;
    private ConcurrentHashMap<Pipeline, PipelineConfig> pipelineConfigs = new ConcurrentHashMap();

    public JsonBuilderElement(Logger logger, ElementDataFactory<JsonBuilderData> elementDataFactory) {
        super(logger, elementDataFactory);
        ArrayList whiteList = new ArrayList();
        this.evidenceKeyFilter = new EvidenceKeyFilterWhitelist(whiteList, String.CASE_INSENSITIVE_ORDER);
        this.properties = Collections.singletonList(new ElementPropertyMetaDataDefault("json", (FlowElement)this, "", String.class, true));
        this.blacklist = Arrays.asList("products", "properties");
        this.elementBlacklist = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.elementBlacklist.add("cloud-response");
        this.elementBlacklist.add("json-builder");
        this.elementBlacklist.add("set-headers");
    }

    protected void processInternal(FlowData data) throws Exception {
        PipelineConfig config;
        if (this.pipelineConfigs.containsKey(data.getPipeline())) {
            config = this.pipelineConfigs.get(data.getPipeline());
        } else {
            config = this.populateMetaDataCollections(data.getPipeline());
            this.pipelineConfigs.putIfAbsent(data.getPipeline(), config);
            config = this.pipelineConfigs.get(data.getPipeline());
        }
        JsonBuilderDataInternal elementData = (JsonBuilderDataInternal)data.getOrAdd(this.getElementDataKey(), this.getDataFactory());
        String jsonString = this.buildJson(data, config);
        elementData.setJson(jsonString);
    }

    public String getElementDataKey() {
        return "json-builder";
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return this.evidenceKeyFilter;
    }

    public List<ElementPropertyMetaData> getProperties() {
        return this.properties;
    }

    protected void managedResourcesCleanup() {
    }

    protected void unmanagedResourcesCleanup() {
    }

    private String buildJson(FlowData data, PipelineConfig config) throws Exception {
        Integer sequenceNumber;
        try {
            sequenceNumber = this.getSequenceNumber(data);
        }
        catch (Exception e) {
            throw new PipelineConfigurationException("Make sure there is a SequenceElement placed before this JsonBuilderElement in the pipeline", (Throwable)e);
        }
        Map<String, Object> allProperties = this.getAllProperties(data, config);
        if (sequenceNumber < Constants.MAX_JAVASCRIPT_ITERATIONS) {
            this.addJavaScriptProperties(data, allProperties);
        }
        this.addErrors(data, allProperties);
        return this.buildJson(allProperties);
    }

    private int getSequenceNumber(FlowData data) throws Exception {
        TryGetResult sequence = data.tryGetEvidence("query.sequence", Integer.class);
        if (!sequence.hasValue()) {
            throw new Exception("Sequence number not present in evidence. this is mandatory.");
        }
        return (Integer)sequence.getValue();
    }

    private Map<String, Object> getAllProperties(FlowData data, PipelineConfig config) throws NoValueException {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        if (config == null) {
            throw new IllegalArgumentException("config");
        }
        HashMap<String, Object> allProperties = new HashMap<String, Object>();
        for (Map.Entry element : data.elementDataAsMap().entrySet()) {
            if (this.elementBlacklist.contains(element.getKey()) || allProperties.containsKey(((String)element.getKey()).toLowerCase())) continue;
            Map<String, Object> elementProperties = this.getValues(((String)element.getKey()).toLowerCase(), ((ElementData)element.getValue()).asKeyMap(), config);
            allProperties.put(((String)element.getKey()).toLowerCase(), elementProperties);
        }
        return allProperties;
    }

    private Map<String, Object> getValues(String dataPath, Map<String, Object> sourceData, PipelineConfig config) throws NoValueException {
        if (dataPath == null) {
            throw new IllegalArgumentException("dataPath");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("sourceData");
        }
        if (config == null) {
            throw new IllegalArgumentException("config");
        }
        dataPath = dataPath.toLowerCase();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, Object> value : sourceData.entrySet()) {
            ArrayList<Map<String, Object>> propertyValue = null;
            if (value.getValue() instanceof AspectPropertyValue) {
                AspectPropertyValue aspectProperty = (AspectPropertyValue)value.getValue();
                if (aspectProperty.hasValue()) {
                    propertyValue = aspectProperty.getValue();
                } else {
                    values.put(value.getKey().toLowerCase(), null);
                    values.put(value.getKey().toLowerCase() + "nullreason", aspectProperty.getNoValueMessage());
                }
            } else {
                propertyValue = value.getValue();
            }
            String completeName = dataPath + "." + value.getKey().toLowerCase();
            if (propertyValue != null) {
                if (propertyValue instanceof List && ((List)propertyValue).size() > 0 && ElementData.class.isAssignableFrom(((List)propertyValue).get(0).getClass())) {
                    List elementDatas = propertyValue;
                    ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
                    for (Object elementData : elementDatas) {
                        results.add(this.getValues(dataPath + "." + value.getKey().toLowerCase(), ((ElementData)elementData).asKeyMap(), config));
                    }
                    propertyValue = results;
                }
                values.put(value.getKey().toLowerCase(), propertyValue);
                if (config.delayedExecutionProperties.contains(completeName)) {
                    values.put(value.getKey().toLowerCase() + "delayexecution", true);
                }
            }
            if (!config.delayedEvidenceProperties.containsKey(completeName)) continue;
            List<String> evidenceProperties = config.delayedEvidenceProperties.get(completeName);
            values.put(value.getKey().toLowerCase() + "evidenceproperties", evidenceProperties);
        }
        return values;
    }

    private void addJavaScriptProperties(FlowData data, Map<String, Object> allProperties) {
        List<String> javascriptProperties = this.getJavaScriptProperties(data, allProperties);
        if (javascriptProperties.size() > 0) {
            allProperties.put(JAVASCRIPT_PROPERTIES_NAME, javascriptProperties);
        }
    }

    private List<String> getJavaScriptProperties(FlowData data, Map<String, Object> allProperties) {
        ArrayList<String> props = new ArrayList<String>();
        for (Map.Entry<String, Object> element : allProperties.entrySet()) {
            Object entryObject = element.getValue();
            if (!(entryObject instanceof Map)) continue;
            Map entry = (Map)entryObject;
            Iterator iterator = entry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry propertyObject;
                Map.Entry property = propertyObject = iterator.next();
                props.add(element.getKey().toLowerCase() + "." + property.getKey().toString().toLowerCase());
            }
        }
        return this.getJavaScriptProperties(data, props);
    }

    private boolean containsIgnoreCase(List<String> list, String key) {
        for (String item : list) {
            if (!item.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private List<String> getJavaScriptProperties(FlowData data, List<String> props) {
        Map javascriptPropertiesMap = data.getWhere((PropertyMatcher)new JsPropertyMatcher());
        String[] keys = new String[]{};
        for (String key : keys = javascriptPropertiesMap.keySet().toArray(keys)) {
            if (this.containsIgnoreCase(props, key)) continue;
            javascriptPropertiesMap.remove(key.toLowerCase());
        }
        ArrayList<String> javascriptPropertyNames = new ArrayList<String>();
        for (String name : javascriptPropertiesMap.keySet()) {
            javascriptPropertyNames.add(name.toLowerCase());
        }
        return javascriptPropertyNames;
    }

    private void addErrors(FlowData data, Map<String, Object> allProperties) {
        if (data.getErrors() != null && data.getErrors().size() > 0) {
            HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
            for (FlowError error : data.getErrors()) {
                if (errors.containsKey(error.getFlowElement().getElementDataKey())) {
                    ((List)errors.get(error.getFlowElement().getElementDataKey())).add(error.getThrowable().getMessage());
                    continue;
                }
                errors.put(error.getFlowElement().getElementDataKey(), Collections.singletonList(error.getThrowable().getMessage()));
            }
            allProperties.put("errors", errors);
        }
    }

    static String resolveName(String name) {
        return name == JAVASCRIPT_PROPERTIES_NAME ? name : name.toLowerCase();
    }

    private String buildJson(Map<String, Object> allProperties) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : allProperties.entrySet()) {
            if (entry.getValue() instanceof Map) {
                HashMap map = new HashMap();
                Map properties = (Map)entry.getValue();
                for (Map.Entry ent : properties.entrySet()) {
                    Object value = ent.getValue();
                    if (value instanceof JavaScript) {
                        value = value.toString();
                    }
                    map.put(JsonBuilderElement.resolveName((String)ent.getKey()), value);
                }
                json.put(JsonBuilderElement.resolveName(entry.getKey()), map);
                continue;
            }
            json.put(JsonBuilderElement.resolveName(entry.getKey()), entry.getValue());
        }
        return json.toString(2);
    }

    private PipelineConfig populateMetaDataCollections(Pipeline pipeline) {
        PipelineConfig config = new PipelineConfig();
        for (Map.Entry element : pipeline.getElementAvailableProperties().entrySet()) {
            for (String string : this.getDelayedPropertyNames(((String)element.getKey()).toLowerCase(), ((Map)element.getValue()).values())) {
                config.delayedExecutionProperties.add(string);
            }
        }
        for (Map.Entry element : pipeline.getElementAvailableProperties().entrySet()) {
            for (Map.Entry entry : this.getEvidencePropertyNames(config.delayedExecutionProperties, ((String)element.getKey()).toLowerCase(), ((String)element.getKey()).toLowerCase(), ((Map)element.getValue()).values()).entrySet()) {
                config.delayedEvidenceProperties.put((String)entry.getKey(), (List)entry.getValue());
            }
        }
        return config;
    }

    private List<String> getDelayedPropertyNames(String dataPath, Collection<ElementPropertyMetaData> properties) {
        ArrayList<String> result = new ArrayList<String>();
        for (ElementPropertyMetaData property : properties) {
            if (property.getDelayExecution() && property.getType().equals(JavaScript.class)) {
                result.add(dataPath + "." + property.getName().toLowerCase());
            }
            if (property.getItemProperties() == null || property.getItemProperties().size() <= 0) continue;
            for (String propertyName : this.getDelayedPropertyNames(dataPath + "." + property.getName(), property.getItemProperties())) {
                result.add(propertyName);
            }
        }
        return result;
    }

    private Map<String, List<String>> getEvidencePropertyNames(HashSet<String> delayedExecutionProperties, String elementDataKey, String propertyDataPath, Collection<ElementPropertyMetaData> properties) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (ElementPropertyMetaData property : properties) {
            ArrayList<String> evidenceProperties = new ArrayList<String>();
            if (property.getEvidenceProperties() != null) {
                for (String evidenceProperty : property.getEvidenceProperties()) {
                    String evidenceName = elementDataKey + "." + evidenceProperty.toLowerCase();
                    if (!delayedExecutionProperties.contains(evidenceName)) continue;
                    evidenceProperties.add(evidenceName);
                }
            }
            if (evidenceProperties.size() > 0) {
                result.put(propertyDataPath + "." + property.getName().toLowerCase(), evidenceProperties);
            }
            if (property.getItemProperties() == null || property.getItemProperties().size() <= 0) continue;
            result.putAll(this.getEvidencePropertyNames(delayedExecutionProperties, elementDataKey, propertyDataPath + "." + property.getName(), property.getItemProperties()));
        }
        return result;
    }

    protected class PipelineConfig {
        public HashSet<String> delayedExecutionProperties = new HashSet();
        public Map<String, List<String>> delayedEvidenceProperties = new HashMap<String, List<String>>();

        protected PipelineConfig() {
        }
    }
}

