/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web;

import fiftyone.pipeline.core.configuration.ElementOptions;
import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.engines.fiftyone.flowelements.SequenceElement;
import fiftyone.pipeline.engines.fiftyone.flowelements.SetHeadersElement;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderElement;
import fiftyone.pipeline.jsonbuilder.flowelements.JsonBuilderElement;

public class StartupHelpers {
    private static int getElementIndex(PipelineOptions options, String name) {
        int index = 0;
        for (ElementOptions element : options.elements) {
            if (element.builderName.toLowerCase().contains(name.toLowerCase())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static Pipeline buildFromConfiguration(PipelineBuilder builder, PipelineOptions options, boolean clientSideEvidenceEnabled) throws Exception {
        return StartupHelpers.buildFromConfiguration(builder, options, clientSideEvidenceEnabled, null);
    }

    public static Pipeline buildFromConfiguration(PipelineBuilder builder, PipelineOptions options, boolean clientSideEvidenceEnabled, String contextRoot) throws Exception {
        if (options == null || options.elements == null || options.elements.size() == 0) {
            throw new PipelineConfigurationException("Could not find pipeline configuration information");
        }
        if (StartupHelpers.getElementIndex(options, SequenceElement.class.getSimpleName()) == -1) {
            ElementOptions sequenceElement = new ElementOptions();
            sequenceElement.builderName = SequenceElement.class.getSimpleName();
            options.elements.add(0, sequenceElement);
        }
        if (clientSideEvidenceEnabled) {
            int jsIndex = StartupHelpers.getElementIndex(options, JavaScriptBuilderElement.class.getSimpleName());
            if (StartupHelpers.getElementIndex(options, JsonBuilderElement.class.getSimpleName()) == -1) {
                ElementOptions jsonBuilderElement = new ElementOptions();
                jsonBuilderElement.builderName = JsonBuilderElement.class.getSimpleName();
                if (jsIndex >= 0) {
                    options.elements.add(jsIndex, jsonBuilderElement);
                    ++jsIndex;
                } else {
                    options.elements.add(jsonBuilderElement);
                }
            }
            if (jsIndex == -1) {
                ElementOptions javaScriptBuilderElement = new ElementOptions();
                javaScriptBuilderElement.builderName = JavaScriptBuilderElement.class.getSimpleName();
                javaScriptBuilderElement.buildParameters.put("Endpoint", "/51Degrees.core.json");
                if (contextRoot != null) {
                    javaScriptBuilderElement.buildParameters.put("ContextRoot", contextRoot);
                }
                options.elements.add(javaScriptBuilderElement);
            } else {
                if (!((ElementOptions)options.elements.get((int)jsIndex)).buildParameters.containsKey("Endpoint")) {
                    ((ElementOptions)options.elements.get((int)jsIndex)).buildParameters.put("Endpoint", "/51Degrees.core.json");
                }
                if (!((ElementOptions)options.elements.get((int)jsIndex)).buildParameters.containsKey("ContextRoot") && contextRoot != null) {
                    ((ElementOptions)options.elements.get((int)jsIndex)).buildParameters.put("ContextRoot", contextRoot);
                }
            }
        }
        if (StartupHelpers.getElementIndex(options, SetHeadersElement.class.getSimpleName()) == -1) {
            ElementOptions setHeadersElement = new ElementOptions();
            setHeadersElement.builderName = SetHeadersElement.class.getSimpleName();
            options.elements.add(setHeadersElement);
        }
        return builder.buildFromConfiguration(options);
    }
}

