/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web.services;

import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.javascriptbuilder.data.JavaScriptBuilderData;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderElement;
import fiftyone.pipeline.jsonbuilder.data.JsonBuilderData;
import fiftyone.pipeline.jsonbuilder.flowelements.JsonBuilderElement;
import fiftyone.pipeline.util.StringManipulation;
import fiftyone.pipeline.web.services.FlowDataProviderCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface ClientsidePropertyServiceCore {
    public void serveJavascript(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public void serveJson(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public static class Default
    implements ClientsidePropertyServiceCore {
        protected static final char PROFILE_OVERRIDES_SPLITTER = '|';
        private final FlowDataProviderCore flowDataProviderCore;
        protected Pipeline pipeline;
        private List<String> headersAffectingJavaScript;
        private final List<String> cacheControl = Arrays.asList("private", "max-age=1800");

        public Default(FlowDataProviderCore flowDataProviderCore, Pipeline pipeline) {
            this.flowDataProviderCore = flowDataProviderCore;
            this.pipeline = pipeline;
            if (pipeline != null) {
                this.init();
            }
        }

        protected void init() {
            this.headersAffectingJavaScript = new ArrayList<String>();
            ArrayList<EvidenceKeyFilter> filters = new ArrayList<EvidenceKeyFilter>();
            for (FlowElement element : this.pipeline.getFlowElements()) {
                filters.add(element.getEvidenceKeyFilter());
            }
            for (EvidenceKeyFilter filter : filters) {
                if (!filter.getClass().equals(EvidenceKeyFilterWhitelist.class)) continue;
                EvidenceKeyFilterWhitelist whitelist = (EvidenceKeyFilterWhitelist)filter;
                for (String key : whitelist.getWhitelist().keySet()) {
                    String header;
                    if (!key.startsWith("header.") || this.hasControlChar(key) || this.headersAffectingJavaScript.contains(header = key.substring(key.indexOf(".") + 1))) continue;
                    this.headersAffectingJavaScript.add(header);
                }
            }
        }

        private boolean hasControlChar(String str) {
            for (char chr : str.toCharArray()) {
                if (chr > '\u001f') continue;
                return true;
            }
            return false;
        }

        @Override
        public void serveJavascript(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.serveContent(request, response, ContentTypes.JavaScript);
        }

        @Override
        public void serveJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.serveContent(request, response, ContentTypes.Json);
        }

        public void serveContent(HttpServletRequest request, HttpServletResponse response, ContentTypes contentType) throws IOException {
            FlowData flowData = this.flowDataProviderCore.getFlowData(request);
            int hash = flowData.generateKey(this.pipeline.getEvidenceKeyFilter()).hashCode();
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null && Integer.toString(hash).equals(request.getHeader("If-None-Match"))) {
                response.setStatus(304);
            } else {
                String content = null;
                switch (contentType) {
                    case JavaScript: {
                        JavaScriptBuilderElement jsElement = (JavaScriptBuilderElement)flowData.getPipeline().getElement(JavaScriptBuilderElement.class);
                        if (jsElement == null) {
                            throw new PipelineConfigurationException("Client-side JavaScript has been requested from the Pipeline. However, the JavaScriptBuilderElement is not present. To resolve this error, either disable client-side evidence or ensure the JavaScriptBuilderElement is added to your Pipeline.");
                        }
                        JavaScriptBuilderData jsData = (JavaScriptBuilderData)flowData.getFromElement((FlowElement)jsElement);
                        content = jsData == null ? null : jsData.getJavaScript();
                        break;
                    }
                    case Json: {
                        JsonBuilderElement jsonElement = (JsonBuilderElement)flowData.getPipeline().getElement(JsonBuilderElement.class);
                        if (jsonElement == null) {
                            throw new PipelineConfigurationException("JSON data has been requested from the Pipeline. However, the JsonBuilderElement is not present. To resolve this error, either disable client-side evidence or ensure the JsonBuilderElement is added to your Pipeline.");
                        }
                        JsonBuilderData jsonData = (JsonBuilderData)flowData.getFromElement((FlowElement)jsonElement);
                        content = jsonData == null ? null : jsonData.getJson();
                        break;
                    }
                }
                this.setHeaders(response, hash, content == null ? 0 : content.length(), contentType == ContentTypes.JavaScript ? "x-javascript" : "json");
                response.getWriter().write(content);
            }
        }

        private void setHeaders(HttpServletResponse response, int hash, int contentLength, String contentType) {
            response.setContentType("application/" + contentType);
            response.setContentLength(contentLength);
            response.setStatus(200);
            response.setHeader("Cache-Control", StringManipulation.stringJoin(this.cacheControl, (String)","));
            response.setHeader("Vary", StringManipulation.stringJoin(this.headersAffectingJavaScript, (String)","));
            response.setHeader("ETag", Integer.toString(hash));
            response.setHeader("Access-Control-Allow-Origin", "*");
        }

        private static enum ContentTypes {
            JavaScript,
            Json;

        }
    }
}

