/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web.services;

import fiftyone.pipeline.web.services.ClientsidePropertyServiceCore;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface FiftyOneJSServiceCore {
    public boolean serveJS(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public boolean serveJson(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public static class Default
    implements FiftyOneJSServiceCore {
        protected final ClientsidePropertyServiceCore clientsidePropertyServiceCore;
        protected boolean enabled;

        public Default(ClientsidePropertyServiceCore clientsidePropertyServiceCore, boolean enabled) {
            this.clientsidePropertyServiceCore = clientsidePropertyServiceCore;
            this.enabled = enabled;
        }

        @Override
        public boolean serveJS(HttpServletRequest request, HttpServletResponse response) throws IOException {
            boolean result = false;
            if (request.getRequestURL().toString().toLowerCase().endsWith("51Degrees.core.js".toLowerCase())) {
                this.serveCoreJS(request, response);
                result = true;
            }
            return result;
        }

        private void serveCoreJS(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (this.enabled) {
                this.clientsidePropertyServiceCore.serveJavascript(request, response);
            }
        }

        @Override
        public boolean serveJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (request == null) {
                throw new IllegalArgumentException("request");
            }
            if (response == null) {
                throw new IllegalArgumentException("response");
            }
            boolean result = false;
            if (request.getRequestURI().toString().toLowerCase().endsWith("51Degrees.core.json".toLowerCase())) {
                this.serveCoreJson(request, response);
                result = true;
            }
            return result;
        }

        private void serveCoreJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (this.enabled) {
                this.clientsidePropertyServiceCore.serveJson(request, response);
            }
        }
    }
}

