/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.drawer.items;

import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.TextView;
import butterknife.ButterKnife;
import com.ftinc.kit.drawer.R;
import com.ftinc.kit.drawer.items.DrawerItem;
import com.ftinc.kit.font.Face;
import com.ftinc.kit.font.FontLoader;
import com.ftinc.kit.preferences.BooleanPreference;

public class SwitchDrawerItem
extends DrawerItem
implements CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private int mText;
    private SwitchCompat mSwitch;
    private BooleanPreference mPreference;

    public SwitchDrawerItem(int id2, int text, BooleanPreference preference) {
        super(id2);
        this.mText = text;
        this.mPreference = preference;
    }

    public SwitchCompat getSwitch() {
        return this.mSwitch;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container) {
        View view = inflater.inflate(R.layout.navdrawer_item_switch, container, false);
        TextView titleView = (TextView)ButterKnife.findById((View)view, (int)R.id.title);
        this.mSwitch = (SwitchCompat)ButterKnife.findById((View)view, (int)R.id.item_switch);
        this.mSwitch.setChecked(this.mPreference.get());
        this.mSwitch.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        view.setOnClickListener((View.OnClickListener)this);
        FontLoader.apply((TextView)titleView, (Face)Face.ROBOTO_MEDIUM);
        titleView.setText(this.mText);
        return view;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.mPreference.set(isChecked);
    }

    public void onClick(View v) {
        this.mSwitch.setChecked(!this.mSwitch.isChecked());
    }
}

