/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.drawer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.os.Handler;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import butterknife.ButterKnife;
import com.ftinc.kit.drawer.Callbacks;
import com.ftinc.kit.drawer.Config;
import com.ftinc.kit.drawer.DrawerInteractor;
import com.ftinc.kit.drawer.R;
import com.ftinc.kit.drawer.items.ActionDrawerItem;
import com.ftinc.kit.drawer.items.DrawerItem;
import com.ftinc.kit.drawer.items.SeperatorDrawerItem;
import com.ftinc.kit.drawer.items.SwitchDrawerItem;
import com.ftinc.kit.util.BuildUtils;
import com.ftinc.kit.util.UIUtils;
import com.ftinc.kit.widget.ScrimInsetsRelativeLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Drawer
implements DrawerInteractor {
    private final Handler mHandler = new Handler();
    private Activity mActivity;
    private Config mConfig;
    private Callbacks mCallbacks;
    private Toolbar mToolbar;
    private ActionBarDrawerToggle mDrawerToggle;
    private View mMainContent;
    private DrawerLayout mDrawerLayout;
    private ScrimInsetsRelativeLayout mDrawerPane;
    private FrameLayout mDrawerContentFrame;
    private FrameLayout mDrawerFooterFrame;
    private FrameLayout mDrawerHeaderFrame;
    private Map<Integer, View> mNavDrawerItemViews = new HashMap<Integer, View>();
    private Map<Integer, DrawerItem> mNavDrawerItems = new HashMap<Integer, DrawerItem>();
    private List<DrawerItem> mDrawerItems = new ArrayList<DrawerItem>();
    private int mSelectedItem;
    private View mHeaderView;
    private View mFooterView;
    private LinearLayout mDrawerItemsListContainer;

    private Drawer(Config config) {
        this.mConfig = config;
        this.mConfig.setDrawerInteractor(this);
    }

    public static Drawer with(Config config) {
        return new Drawer(config);
    }

    public Drawer item(int selectedItem) {
        this.mSelectedItem = selectedItem;
        return this;
    }

    public Drawer toolbar(Toolbar toolbar) {
        this.mToolbar = toolbar;
        return this;
    }

    public Drawer callbacks(Callbacks callbacks) {
        this.mCallbacks = callbacks;
        return this;
    }

    public Drawer attach(Activity activity) {
        this.mActivity = activity;
        this.buildAndAttach();
        return this;
    }

    public boolean isDrawerOpen() {
        return this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(0x800003);
    }

    @Override
    public void closeDrawer() {
        if (this.mDrawerLayout != null) {
            this.mDrawerLayout.closeDrawer(0x800003);
        }
    }

    public void openDrawer() {
        if (this.mDrawerLayout != null) {
            this.mDrawerLayout.openDrawer(0x800003);
        }
    }

    @Override
    public void invalidate() {
        this.populateNavDrawer();
        this.populateHeader();
        this.populateFooter();
    }

    @SuppressLint(value={"NewApi"})
    private void buildAndAttach() {
        this.mActivity.overridePendingTransition(0, 0);
        if (BuildUtils.isLollipop()) {
            Window window = this.mActivity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        }
        this.hiJackDecor();
        this.setupDrawer();
        this.populateNavDrawer();
    }

    private void hiJackDecor() {
        ViewGroup decorView = (ViewGroup)this.mActivity.getWindow().getDecorView();
        ViewGroup mainContent = (ViewGroup)decorView.findViewById(0x1020002);
        this.mMainContent = mainContent.getChildAt(0);
        mainContent.removeViewAt(0);
        this.mDrawerLayout = this.inflateDrawerLayout(mainContent);
        this.mDrawerContentFrame.addView(this.mMainContent, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        mainContent.addView((View)this.mDrawerLayout);
    }

    private void setupDrawer() {
        int statusBarColor;
        int backgroundColor = UIUtils.getColorAttr((Context)this.mActivity, (int)R.attr.drawerBackground);
        if (backgroundColor > 0) {
            this.mDrawerPane.setBackgroundColor(backgroundColor);
        }
        if ((statusBarColor = this.mConfig.getStatusBarColor((Context)this.mActivity)) != -1) {
            this.mDrawerLayout.setStatusBarBackgroundColor(statusBarColor);
        }
        this.populateHeader();
        this.populateFooter();
        final int headerHeight = this.mActivity.getResources().getDimensionPixelSize(R.dimen.navdrawer_chosen_account_height);
        this.mDrawerPane.setOnInsetsCallback(new ScrimInsetsRelativeLayout.OnInsetsCallback(){

            public void onInsetsChanged(Rect insets) {
                if (Drawer.this.mHeaderView != null) {
                    Drawer.this.mConfig.onInsetsChanged(Drawer.this.mHeaderView, insets);
                    ViewGroup.LayoutParams lp2 = Drawer.this.mDrawerHeaderFrame.getLayoutParams();
                    lp2.height = headerHeight + insets.top;
                    Drawer.this.mDrawerHeaderFrame.setLayoutParams(lp2);
                } else {
                    ViewGroup.LayoutParams lp2 = Drawer.this.mDrawerHeaderFrame.getLayoutParams();
                    lp2.height = insets.top;
                    Drawer.this.mDrawerHeaderFrame.setLayoutParams(lp2);
                }
            }
        });
        if (this.mToolbar != null) {
            this.mDrawerToggle = new ActionBarDrawerToggle(this.mActivity, this.mDrawerLayout, this.mToolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close){

                public void onDrawerClosed(View drawerView) {
                    super.onDrawerClosed(drawerView);
                    if (Drawer.this.mCallbacks != null) {
                        Drawer.this.mCallbacks.onDrawerClosed(drawerView);
                    }
                }

                public void onDrawerOpened(View drawerView) {
                    super.onDrawerOpened(drawerView);
                    if (Drawer.this.mCallbacks != null) {
                        Drawer.this.mCallbacks.onDrawerOpened(drawerView);
                    }
                }

                public void onDrawerSlide(View drawerView, float slideOffset) {
                    super.onDrawerSlide(drawerView, Drawer.this.mConfig.shouldAnimateIndicator() ? slideOffset : 0.0f);
                    if (Drawer.this.mCallbacks != null) {
                        Drawer.this.mCallbacks.onDrawerSlide(drawerView, slideOffset);
                    }
                }
            };
            this.mDrawerLayout.post(new Runnable(){

                @Override
                public void run() {
                    Drawer.this.mDrawerToggle.syncState();
                }
            });
            this.mDrawerLayout.setDrawerListener((DrawerLayout.DrawerListener)this.mDrawerToggle);
        }
        this.mDrawerLayout.setDrawerShadow(R.drawable.drawer_shadow, 0x800003);
    }

    private void populateHeader() {
        this.mHeaderView = this.mConfig.inflateHeader(this.mActivity.getLayoutInflater(), (ViewGroup)this.mDrawerHeaderFrame);
        if (this.mHeaderView != null) {
            this.mDrawerHeaderFrame.removeAllViews();
            this.mDrawerHeaderFrame.addView(this.mHeaderView);
            this.mHeaderView.post(new Runnable(){

                @Override
                public void run() {
                    Drawer.this.mConfig.bindHeader(Drawer.this.mHeaderView);
                }
            });
        }
    }

    private void populateFooter() {
        this.mFooterView = this.mConfig.inflateFooter(this.mActivity.getLayoutInflater(), (ViewGroup)this.mDrawerFooterFrame);
        if (this.mFooterView != null) {
            this.mDrawerFooterFrame.removeAllViews();
            this.mDrawerFooterFrame.addView(this.mFooterView);
            this.mFooterView.post(new Runnable(){

                @Override
                public void run() {
                    Drawer.this.mConfig.bindFooter(Drawer.this.mFooterView);
                }
            });
        }
    }

    private void populateNavDrawer() {
        this.mDrawerItems.clear();
        this.mConfig.inflateItems(this.mDrawerItems);
        this.createNavDrawerItems();
    }

    private void createNavDrawerItems() {
        if (this.mDrawerItemsListContainer == null) {
            return;
        }
        this.mNavDrawerItemViews.clear();
        this.mDrawerItemsListContainer.removeAllViews();
        for (DrawerItem item : this.mDrawerItems) {
            item.setSelected(item.getId() == this.mSelectedItem);
            View view = item.onCreateView(this.mActivity.getLayoutInflater(), (ViewGroup)this.mDrawerItemsListContainer, this.mConfig.getItemHighlightColor((Context)this.mActivity));
            if (!(item instanceof SeperatorDrawerItem)) {
                view.setId(item.getId());
                this.mNavDrawerItemViews.put(item.getId(), view);
                this.mNavDrawerItems.put(item.getId(), item);
                if (!(item instanceof SwitchDrawerItem)) {
                    view.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Drawer.this.onNavDrawerItemClicked(v.getId());
                        }
                    });
                }
            }
            this.mDrawerItemsListContainer.addView(view);
        }
    }

    private boolean isSpecialItem(int itemId) {
        DrawerItem item = this.mNavDrawerItems.get(itemId);
        return item instanceof ActionDrawerItem;
    }

    private void onNavDrawerItemClicked(final int itemId) {
        if (itemId == this.mSelectedItem) {
            this.mDrawerLayout.closeDrawer(0x800003);
            return;
        }
        if (this.isSpecialItem(itemId)) {
            this.goToNavDrawerItem(itemId);
        } else {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Drawer.this.goToNavDrawerItem(itemId);
                }
            }, this.mConfig.getLaunchDelay());
            this.setSelectedNavDrawerItem(itemId);
        }
        this.mDrawerLayout.closeDrawer(0x800003);
    }

    private void goToNavDrawerItem(int item) {
        this.mConfig.onDrawerItemClicked(this.mNavDrawerItems.get(item));
    }

    private void setSelectedNavDrawerItem(int itemId) {
        for (DrawerItem item : this.mDrawerItems) {
            this.formatNavDrawerItem(item, itemId == item.getId());
        }
    }

    private void formatNavDrawerItem(DrawerItem item, boolean selected) {
        if (item instanceof SeperatorDrawerItem || item instanceof SwitchDrawerItem) {
            return;
        }
        View view = this.mNavDrawerItemViews.get(item.getId());
        ImageView iconView = (ImageView)view.findViewById(R.id.icon);
        TextView titleView = (TextView)view.findViewById(R.id.title);
        titleView.setTextColor(selected ? this.mConfig.getItemHighlightColor((Context)this.mActivity) : UIUtils.getColorAttr((Context)this.mActivity, (int)16842806));
        iconView.setColorFilter(selected ? this.mConfig.getItemHighlightColor((Context)this.mActivity) : this.getResources().getColor(R.color.navdrawer_icon_tint), PorterDuff.Mode.SRC_ATOP);
    }

    private DrawerLayout inflateDrawerLayout(ViewGroup parent) {
        DrawerLayout drawer = (DrawerLayout)this.mActivity.getLayoutInflater().inflate(R.layout.material_drawer, parent, false);
        this.mDrawerPane = (ScrimInsetsRelativeLayout)ButterKnife.findById((View)drawer, (int)R.id.navdrawer);
        this.mDrawerContentFrame = (FrameLayout)ButterKnife.findById((View)drawer, (int)R.id.drawer_content_frame);
        this.mDrawerHeaderFrame = (FrameLayout)ButterKnife.findById((View)this.mDrawerPane, (int)R.id.header_container);
        this.mDrawerFooterFrame = (FrameLayout)ButterKnife.findById((View)this.mDrawerPane, (int)R.id.footer);
        this.mDrawerItemsListContainer = (LinearLayout)ButterKnife.findById((View)this.mDrawerPane, (int)R.id.navdrawer_items_list);
        return drawer;
    }

    private Resources getResources() {
        return this.mActivity.getResources();
    }
}

