/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.drawer.items;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.ButterKnife;
import com.ftinc.kit.drawer.R;
import com.ftinc.kit.drawer.items.DrawerItem;
import com.ftinc.kit.font.Face;
import com.ftinc.kit.font.FontLoader;
import com.ftinc.kit.util.UIUtils;

public class ActionDrawerItem
extends DrawerItem {
    private int text;
    private int icon;

    public ActionDrawerItem(int id2, int textResId, int iconResId) {
        super(id2);
        this.text = textResId;
        this.icon = iconResId;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, int highlightColor) {
        Context ctx = inflater.getContext();
        View view = inflater.inflate(R.layout.navdrawer_item, container, false);
        ImageView iconView = (ImageView)ButterKnife.findById((View)view, (int)R.id.icon);
        TextView titleView = (TextView)ButterKnife.findById((View)view, (int)R.id.title);
        FontLoader.apply((TextView)titleView, (Face)Face.ROBOTO_MEDIUM);
        titleView.setText(this.text);
        iconView.setVisibility(this.icon > 0 ? 0 : 8);
        if (this.icon > 0) {
            iconView.setImageResource(this.icon);
        }
        titleView.setTextColor(this.selected ? highlightColor : UIUtils.getColorAttr((Context)ctx, (int)16842806));
        iconView.setColorFilter(this.selected ? highlightColor : ctx.getResources().getColor(R.color.navdrawer_icon_tint));
        return view;
    }
}

