/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.drawer.items;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.ButterKnife;
import com.ftinc.kit.drawer.R;
import com.ftinc.kit.drawer.items.DrawerItem;
import com.ftinc.kit.drawer.model.Badge;
import com.ftinc.kit.font.Face;
import com.ftinc.kit.font.FontLoader;
import com.ftinc.kit.util.UIUtils;

public class IconDrawerItem
extends DrawerItem {
    private int textResId;
    private int iconResId;
    private Badge badge;

    private IconDrawerItem(int id2) {
        super(id2);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, int highlightColor) {
        Context ctx = inflater.getContext();
        View view = inflater.inflate(R.layout.navdrawer_item, container, false);
        ImageView iconView = (ImageView)ButterKnife.findById((View)view, (int)R.id.icon);
        TextView titleView = (TextView)ButterKnife.findById((View)view, (int)R.id.title);
        TextView badgeView = (TextView)ButterKnife.findById((View)view, (int)R.id.badge);
        FontLoader.apply((TextView)titleView, (Face)Face.ROBOTO_MEDIUM);
        titleView.setText(this.textResId);
        iconView.setVisibility(this.iconResId > 0 ? 0 : 8);
        if (this.iconResId > 0) {
            iconView.setImageResource(this.iconResId);
        }
        titleView.setTextColor(this.selected ? highlightColor : UIUtils.getColorAttr((Context)ctx, (int)16842806));
        iconView.setColorFilter(this.selected ? highlightColor : ctx.getResources().getColor(R.color.navdrawer_icon_tint));
        if (this.badge != null) {
            Drawable badgeBackground = DrawableCompat.wrap((Drawable)ctx.getResources().getDrawable(R.drawable.badge));
            DrawableCompat.setTint((Drawable)badgeBackground, (int)this.badge.getColor());
            badgeView.setBackground(badgeBackground);
            badgeView.setTextColor(this.badge.getTextColor());
            badgeView.setText((CharSequence)this.badge.getText());
            badgeView.setVisibility(0);
        }
        return view;
    }

    public static class Builder {
        private IconDrawerItem item;

        public Builder(int itemId) {
            this.item = new IconDrawerItem(itemId);
        }

        public Builder text(@StringRes int resId) {
            this.item.textResId = resId;
            return this;
        }

        public Builder icon(@DrawableRes int resId) {
            this.item.iconResId = resId;
            return this;
        }

        public Builder badge(Badge badge) {
            this.item.badge = badge;
            return this;
        }

        public IconDrawerItem build() {
            return this.item;
        }
    }
}

