/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.drawer.model;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;

public class Badge {
    private int color;
    private int textColor;
    private String text;

    public static Builder with(Context ctx) {
        return new Builder(ctx);
    }

    private Badge() {
    }

    @ColorInt
    public int getColor() {
        return this.color;
    }

    @ColorInt
    public int getTextColor() {
        return this.textColor;
    }

    public String getText() {
        return this.text;
    }

    public static class Builder {
        private Context context;
        private Badge badge;

        public Builder(Context ctx) {
            this.context = ctx;
            this.badge = new Badge();
        }

        public Builder color(@ColorRes int resId) {
            this.badge.color = this.context.getResources().getColor(resId);
            return this;
        }

        public Builder badgeColor(@ColorInt int color2) {
            this.badge.color = color2;
            return this;
        }

        public Builder textColor(@ColorRes int resId) {
            this.badge.textColor = this.context.getResources().getColor(resId);
            return this;
        }

        public Builder badgeTextColor(@ColorInt int color2) {
            this.badge.textColor = color2;
            return this;
        }

        public Builder text(String text) {
            this.badge.text = text;
            return this;
        }

        public Builder text(@StringRes int resId) {
            this.badge.text = this.context.getString(resId);
            return this;
        }

        public Badge build() {
            return this.badge;
        }
    }
}

