/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop;

import android.support.annotation.StyleRes;

public final class Flavor {
    private final String mName;
    private final int mStyleResource;
    private final int mDialogStyleResource;
    private final boolean mIsDayNight;

    public Flavor(String name, int styleResource) {
        this(name, styleResource, -1);
    }

    public Flavor(String name, int styleResource, int dialogStyleResource) {
        this(name, styleResource, dialogStyleResource, false);
    }

    public Flavor(String name, int styleResource, int dialogStyleResource, boolean isDayNight) {
        this.mName = name;
        this.mStyleResource = styleResource;
        this.mDialogStyleResource = dialogStyleResource;
        this.mIsDayNight = isDayNight;
    }

    public String getName() {
        return this.mName;
    }

    @StyleRes
    public int getStyleResource() {
        return this.mStyleResource;
    }

    @StyleRes
    public int getDialogStyleResource() {
        return this.mDialogStyleResource;
    }

    public boolean isDayNight() {
        return this.mIsDayNight;
    }

    public String toString() {
        return "Flavor{mName='" + this.mName + '\'' + ", mStyleResource=" + this.mStyleResource + ", mDialogStyleResource=" + this.mDialogStyleResource + ", mIsDayNight=" + this.mIsDayNight + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Flavor flavor = (Flavor)o;
        if (this.mStyleResource != flavor.mStyleResource) {
            return false;
        }
        if (this.mDialogStyleResource != flavor.mDialogStyleResource) {
            return false;
        }
        if (this.mIsDayNight != flavor.mIsDayNight) {
            return false;
        }
        return this.mName != null ? this.mName.equals(flavor.mName) : flavor.mName == null;
    }

    public int hashCode() {
        int result = this.mName != null ? this.mName.hashCode() : 0;
        result = 31 * result + this.mStyleResource;
        result = 31 * result + this.mDialogStyleResource;
        result = 31 * result + (this.mIsDayNight ? 1 : 0);
        return result;
    }
}

