/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.annotation.UiThread;
import android.support.v7.app.AppCompatDelegate;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Interpolator;
import com.ftinc.scoop.Flavor;
import com.ftinc.scoop.R;
import com.ftinc.scoop.SugarCone;
import com.ftinc.scoop.Topping;
import com.ftinc.scoop.adapters.ColorAdapter;
import com.ftinc.scoop.binding.AnimatedBinding;
import com.ftinc.scoop.binding.IBinding;
import com.ftinc.scoop.binding.StatusBarBinding;
import com.ftinc.scoop.binding.ViewBinding;
import com.ftinc.scoop.internal.ToppingBinder;
import com.ftinc.scoop.util.AttrUtils;
import com.ftinc.scoop.util.BindingUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Scoop {
    private static final String TAG = "Scoop";
    private static Scoop _instance = null;
    static final String PREFERENCE_FLAVOR_KEY = "com.ftinc.scoop.preference.FLAVOR_KEY";
    static final String PREFERENCE_DAYNIGHT_KEY = "com.ftinc.scoop.preference.DAY_NIGHT_KEY";
    private List<Flavor> mFlavors = new ArrayList<Flavor>();
    private SparseArray<Topping> mToppings = new SparseArray();
    private HashMap<Class, Set<IBinding>> mBindings = new HashMap();
    private int mDefaultFlavorIndex = 0;
    private boolean mInitialized = false;
    private SharedPreferences mPreferences;
    private SugarCone mSugarCone;
    private static boolean debug = false;

    public static Scoop getInstance() {
        if (_instance == null) {
            _instance = new Scoop();
        }
        return _instance;
    }

    public static Builder waffleCone() {
        return new Builder();
    }

    @Deprecated
    public static SugarCone sugarCone() {
        Scoop instance = Scoop.getInstance();
        instance.checkInit();
        return instance.mSugarCone;
    }

    private Scoop() {
    }

    private void initialize(Builder builder) {
        if (builder.prefs != null && !builder.flavors.isEmpty()) {
            this.mPreferences = builder.prefs;
            this.mFlavors = new ArrayList<Flavor>(builder.flavors);
            if (builder.defaultFlavor != null) {
                this.mDefaultFlavorIndex = this.mFlavors.indexOf(builder.defaultFlavor);
            }
        } else {
            throw new IllegalStateException("SharedPreferences and at least one flavor must be set");
        }
        this.mSugarCone = new SugarCone();
        this.mInitialized = true;
    }

    private int getCurrentFlavorIndex() {
        this.checkInit();
        int flavorIndex = this.mPreferences.getInt(PREFERENCE_FLAVOR_KEY, this.mDefaultFlavorIndex);
        if (flavorIndex > -1 && flavorIndex < this.mFlavors.size()) {
            return flavorIndex;
        }
        return this.mDefaultFlavorIndex;
    }

    private Flavor getCurrentFlavor(boolean excludeDefault) {
        int index = this.getCurrentFlavorIndex();
        if (index != this.mDefaultFlavorIndex || !excludeDefault) {
            return this.mFlavors.get(index);
        }
        return null;
    }

    private void checkInit() {
        if (!this.mInitialized) {
            throw new IllegalStateException("Scoop needs to be initialized first!");
        }
    }

    @NonNull
    @UiThread
    private ToppingBinder<Object> getViewBinder(@NonNull Object target) {
        Class<?> targetClass = target.getClass();
        if (debug) {
            Log.d((String)TAG, (String)("Looking up topping binder for " + targetClass.getName()));
        }
        return this.findViewBinderForClass(targetClass);
    }

    @NonNull
    @UiThread
    private ToppingBinder<Object> findViewBinderForClass(Class<?> cls) {
        ToppingBinder viewBinder = SugarCone.BINDERS.get(cls);
        if (viewBinder != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in topping binder map.");
            }
            return viewBinder;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return SugarCone.NOP_VIEW_BINDER;
        }
        try {
            Class<?> viewBindingClass = Class.forName(clsName + "_ToppingBinder");
            viewBinder = (ToppingBinder)viewBindingClass.newInstance();
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded topping binder class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            viewBinder = this.findViewBinderForClass(cls.getSuperclass());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create topping binder for " + clsName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create topping binder for " + clsName, e);
        }
        SugarCone.BINDERS.put(cls, viewBinder);
        return viewBinder;
    }

    private Set<IBinding> getBindings(Class clazz) {
        Set<IBinding> bindings = this.mBindings.get(clazz);
        if (bindings == null) {
            bindings = new HashSet<IBinding>();
            this.mBindings.put(clazz, bindings);
        }
        return bindings;
    }

    private Topping getOrCreateTopping(int toppingId) {
        Topping topping = (Topping)this.mToppings.get(toppingId);
        if (topping == null) {
            topping = new Topping(toppingId);
            this.mToppings.put(toppingId, (Object)topping);
        }
        return topping;
    }

    private void autoUpdateBinding(IBinding binding, Topping topping) {
        if (topping.getColor() != 0) {
            if (binding instanceof AnimatedBinding) {
                ((AnimatedBinding)binding).update(topping, false);
            } else {
                binding.update(topping);
            }
        }
    }

    public static void setDebug(boolean flag) {
        debug = flag;
    }

    public int getDayNightMode() {
        this.checkInit();
        return this.mPreferences.getInt(PREFERENCE_DAYNIGHT_KEY, -1);
    }

    public List<Flavor> getFlavors() {
        return Collections.unmodifiableList(this.mFlavors);
    }

    public Flavor getCurrentFlavor() {
        return this.getCurrentFlavor(false);
    }

    public void apply(Activity activity) {
        Flavor flavor = this.getCurrentFlavor(true);
        if (flavor != null) {
            if (flavor.isDayNight()) {
                AppCompatDelegate.setDefaultNightMode((int)this.getDayNightMode());
            }
            this.apply(activity, flavor.getStyleResource());
        }
    }

    public void applyDialog(Activity activity) {
        Flavor flavor = this.getCurrentFlavor(true);
        if (flavor != null && flavor.getDialogStyleResource() > -1) {
            if (flavor.isDayNight()) {
                AppCompatDelegate.setDefaultNightMode((int)this.getDayNightMode());
            }
            this.apply(activity, flavor.getDialogStyleResource());
        }
    }

    private void apply(Activity activity, @StyleRes int theme) {
        activity.setTheme(theme);
        int color2 = AttrUtils.getColorAttr((Context)activity, 0x1010031);
        activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(color2));
    }

    public void apply(Context context, Menu menu) {
        Flavor flavor = this.getCurrentFlavor();
        if (menu != null && menu.size() > 0 && flavor != null) {
            int tint = AttrUtils.getColorAttr(context, flavor.getStyleResource(), R.attr.toolbarItemTint);
            for (int i = 0; i < menu.size(); ++i) {
                MenuItem item = menu.getItem(i);
                Drawable icon = item.getIcon();
                if (icon == null) continue;
                if (Build.VERSION.SDK_INT >= 21) {
                    icon.setTint(tint);
                    continue;
                }
                icon.setColorFilter(tint, PorterDuff.Mode.SRC_ATOP);
            }
        }
    }

    public void choose(Flavor item) {
        this.checkInit();
        int index = this.mFlavors.indexOf(item);
        this.mPreferences.edit().putInt(PREFERENCE_FLAVOR_KEY, index).apply();
    }

    public void chooseDayNightMode(int mode) {
        this.checkInit();
        this.mPreferences.edit().putInt(PREFERENCE_DAYNIGHT_KEY, mode).apply();
    }

    public void bind(Activity activity) {
        List<IBinding> bindings = this.getViewBinder(activity).bind(activity);
        for (IBinding binding : bindings) {
            Topping topping = this.getOrCreateTopping(binding.getToppingId());
            this.autoUpdateBinding(binding, topping);
        }
        Set<IBinding> _bindings = this.getBindings(activity.getClass());
        _bindings.addAll(bindings);
    }

    public Scoop bind(Object obj, int toppingId, View view) {
        return this.bind(obj, toppingId, view, null);
    }

    public Scoop bind(Object obj, int toppingId, View view, @Nullable ColorAdapter colorAdapter) {
        return this.bind(obj, toppingId, view, colorAdapter, null);
    }

    public Scoop bind(Object obj, int toppingId, View view, @Nullable ColorAdapter colorAdapter, @Nullable Interpolator interpolator) {
        if (colorAdapter == null) {
            colorAdapter = BindingUtils.getColorAdapter(view.getClass());
        }
        ViewBinding binding = new ViewBinding(toppingId, view, colorAdapter, interpolator);
        return this.bind(obj, toppingId, binding);
    }

    @TargetApi(value=21)
    public Scoop bindStatusBar(Activity activity, int toppingId) {
        return this.bindStatusBar(activity, toppingId, null);
    }

    @TargetApi(value=21)
    public Scoop bindStatusBar(Activity activity, int toppingId, @Nullable Interpolator interpolator) {
        StatusBarBinding binding = new StatusBarBinding(toppingId, activity, interpolator);
        return this.bind((Object)activity, toppingId, binding);
    }

    public Scoop bind(Object obj, int toppingId, IBinding binding) {
        Topping topping = this.getOrCreateTopping(toppingId);
        this.autoUpdateBinding(binding, topping);
        Set<IBinding> bindings = this.getBindings(obj.getClass());
        bindings.add(binding);
        return this;
    }

    public void unbind(Object obj) {
        Set<IBinding> bindings = this.getBindings(obj.getClass());
        for (IBinding binding : bindings) {
            binding.unbind();
        }
        this.mBindings.remove(obj.getClass());
    }

    public Scoop update(int toppingId, @ColorInt int color2) {
        Topping topping = (Topping)this.mToppings.get(toppingId);
        if (topping != null) {
            topping.updateColor(color2);
            Collection<Set<IBinding>> bindings = this.mBindings.values();
            for (Set<IBinding> bindingSet : bindings) {
                for (IBinding binding : bindingSet) {
                    if (binding.getToppingId() != toppingId) continue;
                    binding.update(topping);
                }
            }
        } else {
            throw new InvalidParameterException("Nothing has been bound to the Topping of the given id (" + toppingId + ").");
        }
        return this;
    }

    public static class Builder {
        private SharedPreferences prefs;
        private Flavor defaultFlavor;
        private final List<Flavor> flavors = new ArrayList<Flavor>();

        Builder() {
        }

        public Builder addFlavor(String name, @StyleRes int styleResourceId) {
            return this.addFlavor(name, styleResourceId, -1, false);
        }

        public Builder addDayNightFlavor(String name, @StyleRes int styleResourceId) {
            return this.addFlavor(name, styleResourceId, -1, false, true);
        }

        public Builder addFlavor(String name, @StyleRes int styleResourceId, boolean isDefault) {
            return this.addFlavor(name, styleResourceId, -1, isDefault);
        }

        public Builder addDayNightFlavor(String name, @StyleRes int styleResourceId, boolean isDefault) {
            return this.addFlavor(name, styleResourceId, -1, isDefault, true);
        }

        public Builder addFlavor(String name, @StyleRes int styleResourceId, @StyleRes int dialogStyleResourceId) {
            return this.addFlavor(name, styleResourceId, dialogStyleResourceId, false);
        }

        public Builder addFlavor(String name, @StyleRes int styleResourceId, @StyleRes int dialogStyleResourceId, boolean isDefault) {
            return this.addFlavor(name, styleResourceId, dialogStyleResourceId, isDefault, false);
        }

        public Builder addFlavor(String name, @StyleRes int styleResourceId, @StyleRes int dialogStyleResourceId, boolean isDefault, boolean isDayNight) {
            Flavor flavor = new Flavor(name, styleResourceId, dialogStyleResourceId, isDayNight);
            if (isDefault) {
                this.defaultFlavor = flavor;
            }
            return this.addFlavor(flavor);
        }

        public Builder addFlavor(Flavor ... flavor) {
            this.flavors.addAll(Arrays.asList(flavor));
            return this;
        }

        @Deprecated
        public Builder addToppings(Topping ... toppings) {
            return this;
        }

        public Builder setSharedPreferences(SharedPreferences prefs) {
            this.prefs = prefs;
            return this;
        }

        public void initialize() {
            Scoop.getInstance().initialize(this);
        }
    }
}

