/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop;

import android.app.Activity;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.Interpolator;
import com.ftinc.scoop.Topping;
import com.ftinc.scoop.adapters.ColorAdapter;
import com.ftinc.scoop.binding.IBinding;
import com.ftinc.scoop.binding.StatusBarBinding;
import com.ftinc.scoop.binding.ViewBinding;
import com.ftinc.scoop.internal.ToppingBinder;
import com.ftinc.scoop.util.BindingUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class SugarCone {
    private static final String TAG = "SugarCone";
    static final Map<Class<?>, ToppingBinder<Object>> BINDERS = new LinkedHashMap();
    static final ToppingBinder<Object> NOP_VIEW_BINDER = new ToppingBinder<Object>(){

        @Override
        public List<IBinding> bind(Object target) {
            return new ArrayList<IBinding>();
        }
    };
    private SparseArray<Topping> mToppings = new SparseArray();
    private HashMap<Class, Set<IBinding>> mBindings = new HashMap();
    private static boolean debug = false;

    public void bind(Activity activity) {
        List<IBinding> bindings = SugarCone.getViewBinder(activity).bind(activity);
        Set<IBinding> _bindings = this.getBindings(activity.getClass());
        _bindings.addAll(bindings);
    }

    public SugarCone bind(Object obj, int toppingId, View view) {
        return this.bind(obj, toppingId, view, null);
    }

    public SugarCone bind(Object obj, int toppingId, View view, @Nullable ColorAdapter colorAdapter) {
        return this.bind(obj, toppingId, view, colorAdapter, null);
    }

    public SugarCone bind(Object obj, int toppingId, View view, @Nullable ColorAdapter colorAdapter, @Nullable Interpolator interpolator) {
        if (colorAdapter == null) {
            colorAdapter = BindingUtils.getColorAdapter(view.getClass());
        }
        ViewBinding binding = new ViewBinding(toppingId, view, colorAdapter, interpolator);
        return this.bind(obj, toppingId, binding);
    }

    public SugarCone bindStatusBar(Activity activity, int toppingId) {
        return this.bindStatusBar(activity, toppingId, null);
    }

    public SugarCone bindStatusBar(Activity activity, int toppingId, @Nullable Interpolator interpolator) {
        StatusBarBinding binding = new StatusBarBinding(toppingId, activity, interpolator);
        return this.bind((Object)activity, toppingId, binding);
    }

    public SugarCone bind(Object obj, int toppingId, IBinding binding) {
        Topping topping = (Topping)this.mToppings.get(toppingId);
        if (topping != null) {
            Set<IBinding> bindings = this.getBindings(obj.getClass());
            bindings.add(binding);
            return this;
        }
        throw new InvalidParameterException("No Topping for the given id (" + toppingId + ") was found.");
    }

    public void unbind(Object obj) {
        Set<IBinding> bindings = this.getBindings(obj.getClass());
        for (IBinding binding : bindings) {
            binding.unbind();
        }
        this.mBindings.remove(obj.getClass());
    }

    public SugarCone update(int toppingId, @ColorInt int color2) {
        Topping topping = (Topping)this.mToppings.get(toppingId);
        if (topping != null) {
            topping.updateColor(color2);
            Collection<Set<IBinding>> bindings = this.mBindings.values();
            for (Set<IBinding> bindingSet : bindings) {
                for (IBinding binding : bindingSet) {
                    if (binding.getToppingId() != toppingId) continue;
                    binding.update(topping);
                }
            }
        } else {
            throw new InvalidParameterException("No Topping for the given id (" + toppingId + ") was found.");
        }
        return this;
    }

    @NonNull
    @UiThread
    static ToppingBinder<Object> getViewBinder(@NonNull Object target) {
        Class<?> targetClass = target.getClass();
        if (debug) {
            Log.d((String)TAG, (String)("Looking up topping binder for " + targetClass.getName()));
        }
        return SugarCone.findViewBinderForClass(targetClass);
    }

    @NonNull
    @UiThread
    private static ToppingBinder<Object> findViewBinderForClass(Class<?> cls) {
        ToppingBinder viewBinder = BINDERS.get(cls);
        if (viewBinder != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in topping binder map.");
            }
            return viewBinder;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NOP_VIEW_BINDER;
        }
        try {
            Class<?> viewBindingClass = Class.forName(clsName + "_ToppingBinder");
            viewBinder = (ToppingBinder)viewBindingClass.newInstance();
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded topping binder class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            viewBinder = SugarCone.findViewBinderForClass(cls.getSuperclass());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create topping binder for " + clsName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create topping binder for " + clsName, e);
        }
        BINDERS.put(cls, viewBinder);
        return viewBinder;
    }

    Set<IBinding> getBindings(Class clazz) {
        Set<IBinding> bindings = this.mBindings.get(clazz);
        if (bindings == null) {
            bindings = new HashSet<IBinding>();
            this.mBindings.put(clazz, bindings);
        }
        return bindings;
    }

    public SugarCone addTopping(Topping ... topping) {
        return this.addToppings(Arrays.asList(topping));
    }

    public SugarCone addToppings(Collection<Topping> toppings) {
        for (Topping topping : toppings) {
            this.mToppings.put(topping.getId(), (Object)topping);
        }
        return this;
    }

    public SparseArray<Topping> getToppings() {
        return this.mToppings;
    }
}

