/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop.adapters;

import android.support.annotation.ColorInt;
import android.support.v7.widget.SwitchCompat;
import com.ftinc.scoop.R;
import com.ftinc.scoop.adapters.ColorAdapter;
import com.ftinc.scoop.util.AttrUtils;
import com.ftinc.scoop.util.Utils;

public class SwitchCompatColorAdapter
implements ColorAdapter<SwitchCompat> {
    int disabledColor = 0;
    int trackDisabledColor = 0;

    public void applyColor(SwitchCompat view, @ColorInt int color2) {
        if (this.disabledColor == 0) {
            this.disabledColor = AttrUtils.getColorAttr(view.getContext(), R.attr.colorSwitchThumbNormal);
        }
        if (this.trackDisabledColor == 0) {
            this.trackDisabledColor = view.getContext().getResources().getColor(R.color.grey_600);
        }
        view.setThumbTintList(Utils.colorToStateList(color2, this.disabledColor));
        view.setTrackTintList(Utils.colorToStateList(color2, this.trackDisabledColor));
    }

    public int getColor(SwitchCompat view) {
        if (view.getThumbTintList() != null) {
            return view.getThumbTintList().getDefaultColor();
        }
        return 0;
    }
}

