/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop.binding;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.view.animation.Interpolator;
import com.ftinc.scoop.Topping;
import com.ftinc.scoop.binding.IBinding;

public abstract class AnimatedBinding
extends IBinding {
    private ValueAnimator mAnimator;
    private Interpolator mInterpolator;

    public AnimatedBinding(int toppingId, Interpolator interpolator) {
        super(toppingId);
        this.mInterpolator = interpolator;
    }

    public void update(Topping topping, boolean animate) {
        int toColor;
        int fromColor = topping.getPreviousColor() != 0 ? topping.getPreviousColor() : (this.getCurrentColor() != 0 ? this.getCurrentColor() : -1);
        if (fromColor != (toColor = topping.getColor()) && animate) {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
                this.mAnimator = null;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.mAnimator = ValueAnimator.ofArgb((int[])new int[]{fromColor, toColor}).setDuration(600L);
            } else {
                this.mAnimator = ValueAnimator.ofInt((int[])new int[]{fromColor, toColor}).setDuration(600L);
                this.mAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            }
            if (this.mInterpolator != null) {
                this.mAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
            }
            this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    int colorValue = (Integer)valueAnimator.getAnimatedValue();
                    AnimatedBinding.this.applyColor(colorValue);
                }
            });
            this.mAnimator.start();
        } else {
            this.applyColor(toColor);
        }
    }

    @Override
    public void update(Topping topping) {
        this.update(topping, true);
    }

    @Override
    public void unbind() {
        this.mInterpolator = null;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    @ColorInt
    abstract int getCurrentColor();

    abstract void applyColor(@ColorInt int var1);
}

