/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop.ui;

import android.app.Activity;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.ColorInt;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.ftinc.scoop.Flavor;
import com.ftinc.scoop.R;
import com.ftinc.scoop.Scoop;
import com.ftinc.scoop.util.AttrUtils;
import com.ftinc.scoop.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class FlavorRecyclerAdapter
extends RecyclerView.Adapter<FlavorViewHolder> {
    private final LayoutInflater mInflater;
    private final List<Flavor> mItems;
    private OnItemClickListener mItemClickListener;
    private Flavor mCurrentFlavor;

    public FlavorRecyclerAdapter(Activity activity) {
        this.setHasStableIds(true);
        this.mInflater = activity.getLayoutInflater();
        this.mItems = new ArrayList<Flavor>();
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setCurrentFlavor(Flavor currentFlavor) {
        int index;
        int previousIndex = -1;
        if (this.mCurrentFlavor != null) {
            previousIndex = this.mItems.indexOf(this.mCurrentFlavor);
        }
        this.mCurrentFlavor = currentFlavor;
        if (previousIndex != -1) {
            this.notifyItemChanged(previousIndex);
        }
        if ((index = this.mItems.indexOf(this.mCurrentFlavor)) != -1) {
            this.notifyItemChanged(index);
        }
    }

    public void addAll(List<Flavor> flavors) {
        this.mItems.clear();
        this.mItems.addAll(flavors);
        this.notifyDataSetChanged();
    }

    public FlavorViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return FlavorViewHolder.create(this.mInflater, parent);
    }

    public void onBindViewHolder(final FlavorViewHolder holder, int position) {
        final Flavor item = this.mItems.get(position);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FlavorRecyclerAdapter.this.mItemClickListener != null) {
                    FlavorRecyclerAdapter.this.mItemClickListener.onItemClicked(v, item, holder.getAdapterPosition());
                }
            }
        });
        holder.bind(item, item.equals(this.mCurrentFlavor));
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public long getItemId(int position) {
        Flavor item = this.mItems.get(position);
        if (item != null) {
            return item.hashCode();
        }
        return super.getItemId(position);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(View var1, Flavor var2, int var3);
    }

    static class FlavorViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView mTitle;
        ImageView mPrimary;
        ImageView mDark;
        ImageView mAccent;
        ImageView mIndicator;
        ViewGroup mOptionsGroup;
        Button mOptAuto;
        Button mOptSystem;
        Button mOptOff;
        Button mOptOn;

        static FlavorViewHolder create(LayoutInflater inflater, ViewGroup parent) {
            View view = inflater.inflate(R.layout.item_layout_flavor, parent, false);
            return new FlavorViewHolder(view);
        }

        FlavorViewHolder(View itemView) {
            super(itemView);
            this.mTitle = (TextView)itemView.findViewById(R.id.title);
            this.mPrimary = (ImageView)itemView.findViewById(R.id.primaryColor);
            this.mDark = (ImageView)itemView.findViewById(R.id.primaryColorDark);
            this.mAccent = (ImageView)itemView.findViewById(R.id.accentColor);
            this.mIndicator = (ImageView)itemView.findViewById(R.id.indicator);
            this.mOptionsGroup = (ViewGroup)itemView.findViewById(R.id.daynight_options);
            this.mOptAuto = (Button)this.mOptionsGroup.findViewById(R.id.opt_auto);
            this.mOptSystem = (Button)this.mOptionsGroup.findViewById(R.id.opt_system);
            this.mOptOff = (Button)this.mOptionsGroup.findViewById(R.id.opt_off);
            this.mOptOn = (Button)this.mOptionsGroup.findViewById(R.id.opt_on);
        }

        void bind(Flavor flavor, boolean isCurrentFlavor) {
            this.mTitle.setText((CharSequence)flavor.getName());
            int primary = AttrUtils.getColorAttr(this.itemView.getContext(), flavor.getStyleResource(), R.attr.colorPrimary);
            int primaryDark = AttrUtils.getColorAttr(this.itemView.getContext(), flavor.getStyleResource(), R.attr.colorPrimaryDark);
            int accent = AttrUtils.getColorAttr(this.itemView.getContext(), flavor.getStyleResource(), R.attr.colorAccent);
            this.mPrimary.setBackground((Drawable)this.generateDrawable(primary));
            this.mDark.setBackground((Drawable)this.generateDrawable(primaryDark));
            this.mAccent.setBackground((Drawable)this.generateDrawable(accent));
            this.mIndicator.setVisibility(isCurrentFlavor ? 0 : 8);
            this.mOptionsGroup.setVisibility(flavor.isDayNight() && isCurrentFlavor ? 0 : 8);
            int mode = Scoop.getInstance().getDayNightMode();
            this.bindOptions(mode);
        }

        ShapeDrawable generateDrawable(@ColorInt int color2) {
            ShapeDrawable d = new ShapeDrawable((Shape)new OvalShape());
            d.setIntrinsicWidth(Utils.dipToPx(this.itemView.getContext(), 24.0f));
            d.setIntrinsicHeight(Utils.dipToPx(this.itemView.getContext(), 24.0f));
            d.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            return d;
        }

        void checkMode(Button btn, int mode, int desired) {
            int color2 = AttrUtils.getColorAttr(this.itemView.getContext(), mode == desired ? R.attr.colorAccent : 16842806);
            btn.setTextColor(color2);
            btn.setOnClickListener((View.OnClickListener)this);
        }

        void bindOptions(int mode) {
            this.checkMode(this.mOptAuto, mode, 0);
            this.checkMode(this.mOptSystem, mode, -1);
            this.checkMode(this.mOptOff, mode, 1);
            this.checkMode(this.mOptOn, mode, 2);
        }

        public void onClick(View v) {
            int i = v.getId();
            int mode = 0;
            if (i == R.id.opt_auto) {
                mode = 0;
            } else if (i == R.id.opt_system) {
                mode = -1;
            } else if (i == R.id.opt_off) {
                mode = 1;
            } else if (i == R.id.opt_on) {
                mode = 2;
            }
            AppCompatDelegate.setDefaultNightMode((int)mode);
            Scoop.getInstance().chooseDayNightMode(mode);
            this.bindOptions(mode);
        }
    }
}

