/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import com.ftinc.scoop.Flavor;
import com.ftinc.scoop.R;
import com.ftinc.scoop.Scoop;
import com.ftinc.scoop.ui.FlavorRecyclerAdapter;

public class ScoopSettingsActivity
extends AppCompatActivity
implements FlavorRecyclerAdapter.OnItemClickListener {
    private static final String EXTRA_TITLE = "com.ftinc.scoop.intent.EXTRA_TITLE";
    private Toolbar mAppBar;
    private RecyclerView mRecyclerView;
    private FlavorRecyclerAdapter mAdapter;
    private String mTitle;

    public static Intent createIntent(Context ctx) {
        return ScoopSettingsActivity.createIntent(ctx, null);
    }

    public static Intent createIntent(Context ctx, @StringRes int titleResId) {
        return ScoopSettingsActivity.createIntent(ctx, ctx.getString(titleResId));
    }

    public static Intent createIntent(Context ctx, @Nullable String title) {
        Intent intent = new Intent(ctx, ScoopSettingsActivity.class);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            intent.putExtra(EXTRA_TITLE, title);
        }
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Scoop.getInstance().apply((Activity)this);
        this.setContentView(R.layout.activity_scoop_settings);
        this.parseExtras(savedInstanceState);
        this.setupActionBar();
        this.setupRecyclerView();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(EXTRA_TITLE, this.mTitle);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void parseExtras(Bundle savedInstanceState) {
        if (this.getIntent() != null) {
            this.mTitle = this.getIntent().getStringExtra(EXTRA_TITLE);
        }
        if (savedInstanceState != null) {
            this.mTitle = savedInstanceState.getString(EXTRA_TITLE);
        }
    }

    private void setupActionBar() {
        if (this.getSupportActionBar() == null) {
            this.mAppBar = (Toolbar)this.findViewById(R.id.appbar);
            this.setSupportActionBar(this.mAppBar);
            this.mAppBar.setVisibility(0);
            this.mAppBar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ScoopSettingsActivity.this.finish();
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.getSupportActionBar().setTitle(R.string.activity_settings);
        } else {
            this.getSupportActionBar().setTitle((CharSequence)this.mTitle);
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    private void setupRecyclerView() {
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler);
        this.mAdapter = new FlavorRecyclerAdapter((Activity)this);
        this.mAdapter.setItemClickListener(this);
        this.mAdapter.addAll(Scoop.getInstance().getFlavors());
        this.mAdapter.setCurrentFlavor(Scoop.getInstance().getCurrentFlavor());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
    }

    @Override
    public void onItemClicked(View view, Flavor item, int position) {
        Scoop.getInstance().choose(item);
        this.mAdapter.setCurrentFlavor(item);
        Intent restart = new Intent((Context)this, ScoopSettingsActivity.class);
        this.setResult(-1);
        this.finish();
        this.startActivity(restart);
        this.overridePendingTransition(0, 0);
    }
}

