/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.scoop.util;

import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.ftinc.scoop.adapters.ColorAdapter;
import com.ftinc.scoop.adapters.DefaultColorAdapter;
import com.ftinc.scoop.adapters.ImageViewColorAdapter;
import com.ftinc.scoop.adapters.SwitchCompatColorAdapter;
import com.ftinc.scoop.adapters.TextViewColorAdapter;
import com.ftinc.scoop.adapters.ViewGroupColorAdapter;
import java.util.HashMap;
import java.util.Map;

public class BindingUtils {
    private static final Map<Class, ColorAdapter> COLOR_ADAPTERS = new HashMap<Class, ColorAdapter>(){
        {
            this.put(View.class, new DefaultColorAdapter());
            this.put(ViewGroup.class, new ViewGroupColorAdapter());
            this.put(TextView.class, new TextViewColorAdapter());
            this.put(ImageView.class, new ImageViewColorAdapter());
            this.put(SwitchCompat.class, new SwitchCompatColorAdapter());
        }
    };

    private BindingUtils() {
        throw new IllegalAccessError("This class is not allowed to be instantiated");
    }

    public static <T extends View> ColorAdapter<T> getColorAdapter(Class<T> clazz) {
        ColorAdapter adapter = COLOR_ADAPTERS.get(clazz);
        if (adapter == null && (adapter = COLOR_ADAPTERS.get(clazz.getSuperclass())) == null) {
            adapter = new DefaultColorAdapter();
        }
        return adapter;
    }
}

