/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver;

import com.eightkdata.mongowp.mongoserver.MongoServerConfig;
import com.eightkdata.mongowp.mongoserver.ReplyMessageObjectHandler;
import com.eightkdata.mongowp.mongoserver.RequestIdGenerator;
import com.eightkdata.mongowp.mongoserver.RequestMessageByteHandler;
import com.eightkdata.mongowp.mongoserver.RequestMessageObjectHandler;
import com.eightkdata.mongowp.mongoserver.callback.RequestProcessor;
import com.eightkdata.mongowp.mongoserver.util.LengthFieldPrependerLittleEndian;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoServer
implements RequestIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoServer.class);
    private final int port;
    private final RequestProcessor requestProcessor;
    private final AtomicInteger requestId;
    private EventLoopGroup connectionGroup;
    private EventLoopGroup workerGroup;

    @Inject
    public MongoServer(MongoServerConfig mongoServerConfig, RequestProcessor requestProcessor) {
        this.port = mongoServerConfig.getPort();
        this.requestProcessor = requestProcessor;
        this.requestId = new AtomicInteger(0);
    }

    @Override
    public int getNextRequestId() {
        return this.requestId.incrementAndGet();
    }

    private void buildChildHandlerPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(ByteOrder.LITTLE_ENDIAN, 48000000, 0, 4, -4, 4, true)});
        pipeline.addLast(new ChannelHandler[]{new RequestMessageByteHandler()});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrependerLittleEndian(4, true)});
        pipeline.addLast(new ChannelHandler[]{new ReplyMessageObjectHandler(this)});
        pipeline.addLast(new ChannelHandler[]{new RequestMessageObjectHandler(this.requestProcessor)});
    }

    public void run() {
        this.connectionGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.connectionGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                MongoServer.this.buildChildHandlerPipeline(socketChannel.pipeline());
            }
        });
        ChannelFuture channelFuture = bootstrap.bind(this.port).awaitUninterruptibly();
        if (!channelFuture.isSuccess()) {
            this.workerGroup.shutdownGracefully();
            this.connectionGroup.shutdownGracefully();
        }
    }

    public void stop() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully().syncUninterruptibly();
        }
        if (this.connectionGroup != null) {
            this.connectionGroup.shutdownGracefully().syncUninterruptibly();
        }
    }
}

