/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver;

import com.eightkdata.mongowp.messages.request.RequestBaseMessage;
import com.eightkdata.mongowp.messages.request.RequestOpCode;
import com.eightkdata.mongowp.mongoserver.decoder.BaseMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.MessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.MessageDecoderLocator;
import com.eightkdata.mongowp.mongoserver.exception.InvalidMessageException;
import com.eightkdata.mongowp.mongoserver.util.ChannelLittleEndianHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class RequestMessageByteHandler
extends ChannelLittleEndianHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestMessageByteHandler.class);
    private static final String INVALID_OPCODE_MESSAGE = "Received and invalid message with opCode ";
    private static final String OPERATION_NOT_IMPLEMENTED = "Message decoder not implemented for opCode ";

    @Override
    protected void decodeLittleEndian(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> objects) throws Exception {
        if (byteBuf instanceof EmptyByteBuf) {
            return;
        }
        RequestBaseMessage requestBaseMessage = BaseMessageDecoder.decode(channelHandlerContext, byteBuf);
        byteBuf.skipBytes(4);
        int requestOpCodeInt = byteBuf.readInt();
        RequestOpCode requestOpCode = RequestOpCode.getByOpcode((int)requestOpCodeInt);
        if (null == requestOpCode) {
            LOGGER.warn(INVALID_OPCODE_MESSAGE + requestOpCodeInt);
            throw new InvalidMessageException(INVALID_OPCODE_MESSAGE + requestOpCodeInt);
        }
        MessageDecoder<?> messageDecoder = MessageDecoderLocator.getByOpCode(requestOpCode);
        if (null == messageDecoder) {
            LOGGER.error(OPERATION_NOT_IMPLEMENTED + requestOpCode);
            throw new UnsupportedOperationException(OPERATION_NOT_IMPLEMENTED + requestOpCode);
        }
        objects.add(messageDecoder.decode(byteBuf, requestBaseMessage));
    }
}

