/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver;

import com.eightkdata.mongowp.messages.request.DeleteMessage;
import com.eightkdata.mongowp.messages.request.GetMoreMessage;
import com.eightkdata.mongowp.messages.request.InsertMessage;
import com.eightkdata.mongowp.messages.request.KillCursorsMessage;
import com.eightkdata.mongowp.messages.request.QueryMessage;
import com.eightkdata.mongowp.messages.request.RequestMessage;
import com.eightkdata.mongowp.messages.request.RequestOpCode;
import com.eightkdata.mongowp.messages.request.UpdateMessage;
import com.eightkdata.mongowp.mongoserver.callback.NettyMessageReplier;
import com.eightkdata.mongowp.mongoserver.callback.RequestProcessor;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageObjectHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestMessageObjectHandler.class);
    public static final AttributeKey<RequestOpCode> REQUEST_OP_CODE = AttributeKey.valueOf((String)"requestOpCode");
    private final RequestProcessor requestProcessor;

    @Inject
    public RequestMessageObjectHandler(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RequestMessage requestMessage = (RequestMessage)msg;
        ctx.attr(NettyMessageReplier.REQUEST_ID).set((Object)requestMessage.getBaseMessage().getRequestId());
        LOGGER.debug("Received message type: {}, data: {}", (Object)requestMessage.getOpCode(), (Object)requestMessage);
        NettyMessageReplier messageReplier = new NettyMessageReplier(ctx);
        ctx.attr(REQUEST_OP_CODE).set((Object)requestMessage.getOpCode());
        switch (requestMessage.getOpCode()) {
            case OP_QUERY: {
                assert (requestMessage instanceof QueryMessage);
                this.requestProcessor.queryMessage((QueryMessage)requestMessage, messageReplier);
                break;
            }
            case OP_GET_MORE: {
                assert (requestMessage instanceof GetMoreMessage);
                this.requestProcessor.getMore((GetMoreMessage)requestMessage, messageReplier);
                break;
            }
            case OP_KILL_CURSORS: {
                assert (requestMessage instanceof KillCursorsMessage);
                this.requestProcessor.killCursors((KillCursorsMessage)requestMessage, messageReplier);
                break;
            }
            case OP_INSERT: {
                assert (requestMessage instanceof InsertMessage);
                this.requestProcessor.insert((InsertMessage)requestMessage, messageReplier);
                break;
            }
            case OP_UPDATE: {
                assert (requestMessage instanceof UpdateMessage);
                this.requestProcessor.update((UpdateMessage)requestMessage, messageReplier);
                break;
            }
            case OP_DELETE: {
                assert (requestMessage instanceof DeleteMessage);
                this.requestProcessor.delete((DeleteMessage)requestMessage, messageReplier);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Message replier not implemented for " + requestMessage.getOpCode() + " opCode");
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("Error while processing request", cause);
        NettyMessageReplier messageReplier = new NettyMessageReplier(ctx);
        this.requestProcessor.handleError((RequestOpCode)ctx.attr(REQUEST_OP_CODE).get(), messageReplier, cause);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.requestProcessor.onChannelActive((AttributeMap)ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.requestProcessor.onChannelInactive((AttributeMap)ctx);
    }
}

