/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.callback;

import com.eightkdata.mongowp.messages.response.ReplyMessage;
import com.eightkdata.mongowp.mongoserver.protocol.MongoWP;
import io.netty.util.AttributeMap;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public abstract class MessageReplier {
    public abstract int getRequestId();

    public abstract AttributeMap getAttributeMap();

    public abstract void replyMessage(ReplyMessage var1);

    private void replyMessageBuilder(ReplyMessage.Builder builder) {
        this.replyMessage(builder.build());
    }

    public void replyMessage(long cursorId, int startingFrom, @Nonnull BsonDocument document) {
        this.replyMessageBuilder(new ReplyMessage.Builder(this.getRequestId(), cursorId, startingFrom, document));
    }

    public void replyMessageNoCursor(BsonDocument document) {
        this.replyMessage(0L, 0, document);
    }

    public void replyMessageNoCursor(Iterable<? extends BsonDocument> documents) {
        ReplyMessage.Builder builder = new ReplyMessage.Builder(this.getRequestId(), 0L, 0);
        Iterator<? extends BsonDocument> iterator = documents.iterator();
        while (iterator.hasNext()) {
            builder.addBsonDocument(iterator.next());
        }
        this.replyMessageBuilder(builder);
    }

    private ReplyMessage.Builder getReplyMessageBuilder(long cursorId, int startingFrom, @Nonnull BsonDocument firstDocument, BsonDocument ... documents) {
        ReplyMessage.Builder builder = new ReplyMessage.Builder(this.getRequestId(), cursorId, startingFrom, firstDocument);
        for (BsonDocument document : documents) {
            builder.addBsonDocument(document);
        }
        return builder;
    }

    public void replyMessageMultipleDocuments(long cursorId, int startingFrom, @Nonnull BsonDocument firstDocument, BsonDocument ... documents) {
        this.replyMessageBuilder(this.getReplyMessageBuilder(cursorId, startingFrom, firstDocument, documents));
    }

    public void replyMessageMultipleDocuments(long cursorId, int startingFrom, @Nonnull Iterable<BsonDocument> documents) {
        this.replyMessageMultipleDocumentsWithFlags(cursorId, startingFrom, documents, EnumSet.noneOf(ReplyMessage.Flag.class));
    }

    public void replyMessageMultipleDocumentsWithFlags(long cursorId, int startingFrom, @Nonnull Iterable<BsonDocument> documents, @Nonnull EnumSet<ReplyMessage.Flag> flags) {
        Iterator<BsonDocument> iterator = documents.iterator();
        ReplyMessage.Builder builder = new ReplyMessage.Builder(this.getRequestId(), cursorId, startingFrom);
        while (iterator.hasNext()) {
            builder.addBsonDocument(iterator.next());
        }
        this.replyMessageBuilder(builder.setFlags(flags));
    }

    public void replyMessageWithFlags(long cursorId, int startingFrom, @Nonnull EnumSet<ReplyMessage.Flag> flags) {
        ReplyMessage.Builder builder = new ReplyMessage.Builder(this.getRequestId(), cursorId, startingFrom);
        this.replyMessageBuilder(builder.setFlags(flags));
    }

    public void replyMessageWithFlags(@Nonnull EnumSet<ReplyMessage.Flag> flags, long cursorId, int startingFrom, @Nonnull BsonDocument firstDocument, BsonDocument ... documents) {
        this.replyMessageBuilder(this.getReplyMessageBuilder(cursorId, startingFrom, firstDocument, documents).setFlags(flags));
    }

    public void replyQueryFailure(@Nonnull String errorMessage, @Nonnegative int errorCode, Object ... args) {
        BsonDocument errorDocument = new BsonDocument();
        errorDocument.put("ok", (BsonValue)MongoWP.BSON_KO);
        errorDocument.put("$err", (BsonValue)new BsonString(MessageFormat.format(errorMessage, args)));
        errorDocument.put("code", (BsonValue)new BsonInt32(errorCode));
        this.replyMessageWithFlags(EnumSet.of(ReplyMessage.Flag.QUERY_FAILURE), 0L, 0, errorDocument, new BsonDocument[0]);
    }

    public void replyQueryFailure(@Nonnull MongoWP.ErrorCode errorCode, Object ... args) {
        this.replyQueryFailure(errorCode.getErrorMessage(), errorCode.getErrorCode(), args);
    }

    public void replyQueryCommandFailure(@Nonnull String errorMessage, @Nonnegative int errorCode, Object ... args) {
        BsonDocument errorDocument = new BsonDocument();
        errorDocument.put("ok", (BsonValue)MongoWP.BSON_KO);
        errorDocument.put("errmsg", (BsonValue)new BsonString(MessageFormat.format(errorMessage, args)));
        errorDocument.put("code", (BsonValue)new BsonInt32(errorCode));
        this.replyMessageWithFlags(EnumSet.of(ReplyMessage.Flag.QUERY_FAILURE), 0L, 0, errorDocument, new BsonDocument[0]);
    }

    public void replyQueryCommandFailure(@Nonnull MongoWP.ErrorCode errorCode, Object ... args) {
        this.replyQueryCommandFailure(errorCode.getErrorMessage(), errorCode.getErrorCode(), args);
    }

    public void replyWriteFailure(@Nonnull String errorMessage, @Nonnegative int errorCode, Object ... args) {
        BsonDocument errorDocument = new BsonDocument();
        errorDocument.put("ok", (BsonValue)MongoWP.BSON_KO);
        errorDocument.put("errmsg", (BsonValue)new BsonString(MessageFormat.format(errorMessage, args)));
        errorDocument.put("code", (BsonValue)new BsonInt32(errorCode));
        this.replyMessageWithFlags(EnumSet.of(ReplyMessage.Flag.QUERY_FAILURE), 0L, 0, errorDocument, new BsonDocument[0]);
    }

    public void replyWriteFailure(@Nonnull MongoWP.ErrorCode errorCode, Object ... args) {
        this.replyWriteFailure(errorCode.getErrorMessage(), errorCode.getErrorCode(), args);
    }

    public void replyGetMoreFailure(@Nonnull String errorMessage, @Nonnegative int errorCode, Object ... args) {
        BsonDocument errorDocument = new BsonDocument();
        errorDocument.put("ok", (BsonValue)MongoWP.BSON_KO);
        errorDocument.put("$err", (BsonValue)new BsonString(MessageFormat.format(errorMessage, args)));
        errorDocument.put("code", (BsonValue)new BsonInt32(errorCode));
        this.replyMessageWithFlags(EnumSet.of(ReplyMessage.Flag.CURSOR_NOT_FOUND), 0L, 0, errorDocument, new BsonDocument[0]);
    }

    public void replyGetMoreFailure(@Nonnull MongoWP.ErrorCode errorCode) {
        this.replyGetMoreFailure(errorCode.getErrorMessage(), errorCode.getErrorCode(), new Object[0]);
    }

    public void replyKillCursorsFailure(@Nonnull String errorMessage, @Nonnegative int errorCode, Object ... args) {
        BsonDocument errorDocument = new BsonDocument();
        errorDocument.put("ok", (BsonValue)MongoWP.BSON_KO);
        errorDocument.put("$err", (BsonValue)new BsonString(MessageFormat.format(errorMessage, args)));
        errorDocument.put("code", (BsonValue)new BsonInt32(errorCode));
        this.replyMessageWithFlags(EnumSet.noneOf(ReplyMessage.Flag.class), 0L, 0, errorDocument, new BsonDocument[0]);
    }

    public void replyKillCursorsFailure(@Nonnull MongoWP.ErrorCode errorCode) {
        this.replyKillCursorsFailure(errorCode.getErrorMessage(), errorCode.getErrorCode(), new Object[0]);
    }
}

