/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.callback;

import com.eightkdata.mongowp.messages.response.ReplyMessage;
import com.eightkdata.mongowp.mongoserver.callback.MessageReplier;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMessageReplier
extends MessageReplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyMessageReplier.class);
    public static final AttributeKey<Integer> REQUEST_ID = AttributeKey.valueOf((String)"requestId");
    private final ChannelHandlerContext channelHandlerContext;

    public NettyMessageReplier(@Nonnull ChannelHandlerContext channelHandlerContext) {
        Preconditions.checkNotNull((Object)channelHandlerContext);
        this.channelHandlerContext = channelHandlerContext;
    }

    @Override
    public int getRequestId() {
        return (Integer)this.channelHandlerContext.attr(REQUEST_ID).get();
    }

    @Override
    public AttributeMap getAttributeMap() {
        return this.channelHandlerContext;
    }

    @Override
    public void replyMessage(ReplyMessage replyMessage) {
        this.channelHandlerContext.writeAndFlush((Object)replyMessage);
        LOGGER.debug("Replying " + replyMessage);
    }
}

