/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.decoder;

import com.eightkdata.mongowp.messages.request.InsertMessage;
import com.eightkdata.mongowp.messages.request.RequestBaseMessage;
import com.eightkdata.mongowp.mongoserver.decoder.MessageDecoder;
import com.eightkdata.mongowp.mongoserver.exception.InvalidMessageException;
import com.eightkdata.mongowp.mongoserver.util.ByteBufUtil;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.inject.Singleton;

@Singleton
public class InsertMessageDecoder
implements MessageDecoder<InsertMessage> {
    @Override
    @Nonnegative
    public InsertMessage decode(ByteBuf buffer, RequestBaseMessage requestBaseMessage) throws InvalidMessageException {
        int flags = buffer.readInt();
        String fullCollectionName = ByteBufUtil.readCString(buffer);
        ArrayList documents = Lists.newArrayList();
        while (buffer.readableBytes() > 0) {
            documents.add(ByteBufUtil.readBsonDocument(buffer));
        }
        return new InsertMessage(requestBaseMessage, flags, fullCollectionName, (List)documents);
    }
}

