/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.decoder;

import com.eightkdata.mongowp.messages.request.KillCursorsMessage;
import com.eightkdata.mongowp.messages.request.RequestBaseMessage;
import com.eightkdata.mongowp.mongoserver.decoder.MessageDecoder;
import com.eightkdata.mongowp.mongoserver.exception.InvalidMessageException;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnegative;
import javax.inject.Singleton;

@Singleton
public class KillCursorsMessageDecoder
implements MessageDecoder<KillCursorsMessage> {
    @Override
    @Nonnegative
    public KillCursorsMessage decode(ByteBuf buffer, RequestBaseMessage requestBaseMessage) throws InvalidMessageException {
        buffer.skipBytes(4);
        int numberOfCursors = buffer.readInt();
        long[] cursorIds = new long[numberOfCursors];
        for (int index = 0; index < numberOfCursors; ++index) {
            cursorIds[index] = buffer.readLong();
        }
        return new KillCursorsMessage(requestBaseMessage, numberOfCursors, cursorIds);
    }
}

