/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.decoder;

import com.eightkdata.mongowp.messages.request.RequestOpCode;
import com.eightkdata.mongowp.mongoserver.decoder.DeleteMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.GetMoreMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.InsertMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.KillCursorsMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.MessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.QueryMessageDecoder;
import com.eightkdata.mongowp.mongoserver.decoder.UpdateMessageDecoder;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public enum MessageDecoderLocator {
    OP_QUERY(RequestOpCode.OP_QUERY, new QueryMessageDecoder()),
    OP_GET_MORE(RequestOpCode.OP_GET_MORE, new GetMoreMessageDecoder()),
    OP_KILL_CURSORS(RequestOpCode.OP_KILL_CURSORS, new KillCursorsMessageDecoder()),
    OP_INSERT(RequestOpCode.OP_INSERT, new InsertMessageDecoder()),
    OP_UPDATE(RequestOpCode.OP_UPDATE, new UpdateMessageDecoder()),
    OP_DELETE(RequestOpCode.OP_DELETE, new DeleteMessageDecoder());

    @Nonnull
    private RequestOpCode opCode;
    @Nonnull
    private MessageDecoder<?> messageDecoder;
    private static EnumMap<RequestOpCode, MessageDecoder<?>> OP_CODES_MAP;

    private MessageDecoderLocator(RequestOpCode opCode, MessageDecoder<?> messageDecoder) {
        this.opCode = opCode;
        this.messageDecoder = messageDecoder;
    }

    public static MessageDecoder<?> getByOpCode(@Nonnull RequestOpCode requestOpCode) {
        return OP_CODES_MAP.get(requestOpCode);
    }

    static {
        OP_CODES_MAP = new EnumMap(RequestOpCode.class);
        for (MessageDecoderLocator value : MessageDecoderLocator.values()) {
            OP_CODES_MAP.put(value.opCode, value.messageDecoder);
        }
    }
}

