/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.encoder;

import com.eightkdata.mongowp.messages.response.ReplyMessage;
import com.eightkdata.mongowp.messages.response.ResponseOpCode;
import com.eightkdata.mongowp.messages.util.EnumInt32FlagsUtil;
import com.eightkdata.mongowp.mongoserver.util.ByteBufUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.bson.BsonDocument;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="It seems FindBugs considers ByteBuf methods are not side effect")
public class ReplyMessageEncoder {
    public static void encodeMessageHeader(ByteBuf buffer, ReplyMessage message, int requestId) {
        buffer.writeInt(requestId);
        buffer.writeInt(message.getResponseTo());
        buffer.writeInt(ResponseOpCode.OP_REPLY.getOpCode());
    }

    public static void encodeMessageBody(ByteBuf buffer, ReplyMessage message) {
        buffer.writeInt(EnumInt32FlagsUtil.getInt32Flags((Set)message.getFlags()));
        buffer.writeLong(message.getCursorId());
        buffer.writeInt(message.getStartingFrom());
        buffer.writeInt(message.getDocuments().size());
        for (BsonDocument document : message.getDocuments()) {
            ByteBufUtil.writeBsonDocument(buffer, document);
        }
    }
}

