/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.pojos;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedInts;
import java.io.Serializable;
import org.bson.BsonTimestamp;
import org.threeten.bp.Instant;

public class OpTime
implements Comparable<OpTime>,
Serializable {
    public static final OpTime EPOCH = new OpTime(0, 0);
    private static final long serialVersionUID = 1L;
    private final int secs;
    private final int term;

    public OpTime(Instant instant) {
        this.secs = UnsignedInteger.valueOf((long)instant.getEpochSecond()).intValue();
        this.term = UnsignedInteger.valueOf((long)instant.getNano()).intValue();
    }

    public OpTime(Instant instant, UnsignedInteger term) {
        this.secs = UnsignedInteger.valueOf((long)instant.getEpochSecond()).intValue();
        this.term = term.intValue();
    }

    public OpTime(UnsignedInteger secs, UnsignedInteger term) {
        this.secs = secs.intValue();
        this.term = term.intValue();
    }

    public OpTime(int secs, int term) {
        this.secs = secs;
        this.term = term;
    }

    public UnsignedInteger getSecs() {
        return UnsignedInteger.fromIntBits((int)this.secs);
    }

    public UnsignedInteger getTerm() {
        return UnsignedInteger.fromIntBits((int)this.term);
    }

    public BsonTimestamp asBsonTimestamp() {
        return new BsonTimestamp(this.secs, this.term);
    }

    public long toEpochMilli() {
        return UnsignedInts.toLong((int)this.secs) * 1000L;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.secs;
        hash = 59 * hash + this.term;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpTime other = (OpTime)obj;
        if (this.secs != other.secs) {
            return false;
        }
        return this.term == other.term;
    }

    @Override
    public int compareTo(OpTime o) {
        int diff = UnsignedInts.compare((int)this.secs, (int)o.secs);
        if (diff != 0) {
            return diff;
        }
        return UnsignedInts.compare((int)this.term, (int)o.term);
    }

    public String toString() {
        return "{t: " + UnsignedInteger.fromIntBits((int)this.secs) + ", i: " + UnsignedInteger.fromIntBits((int)this.term) + "}";
    }
}

