/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.util;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import org.bson.io.BsonInput;
import org.bson.types.ObjectId;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="It seems FindBugs considers ByteBuf methods are not side effect")
public class ByteBufBsonInputAdaptor
implements BsonInput {
    private static final Charset UTF8_CHARSET = Charsets.UTF_8;
    private final ByteBuf buffer;
    private boolean closed;
    private int mark = -1;

    public ByteBufBsonInputAdaptor(ByteBuf byteBuf) {
        this.buffer = byteBuf;
        this.closed = false;
    }

    public int getPosition() {
        return this.buffer.readerIndex();
    }

    public byte readByte() {
        this.ensureOpen();
        return this.buffer.readByte();
    }

    public void readBytes(byte[] bytes) {
        this.ensureOpen();
        this.buffer.readBytes(bytes);
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        this.ensureOpen();
        this.buffer.readBytes(bytes, offset, length);
    }

    public long readInt64() {
        this.ensureOpen();
        return this.buffer.readLong();
    }

    public double readDouble() {
        this.ensureOpen();
        return this.buffer.readDouble();
    }

    public int readInt32() {
        this.ensureOpen();
        return this.buffer.readInt();
    }

    public String readString() {
        this.ensureOpen();
        int size = this.readInt32();
        byte[] bytes = new byte[size];
        this.readBytes(bytes);
        return new String(bytes, 0, size - 1, UTF8_CHARSET);
    }

    public ObjectId readObjectId() {
        this.ensureOpen();
        byte[] bytes = new byte[12];
        this.readBytes(bytes);
        return new ObjectId(bytes);
    }

    public String readCString() {
        this.ensureOpen();
        int strSize = this.buffer.bytesBefore((byte)0);
        if (strSize < 0) {
            throw new AssertionError((Object)"Expected a CString but no '0' character was found");
        }
        byte[] bytes = new byte[strSize];
        this.readBytes(bytes);
        this.readByte();
        return new String(bytes, UTF8_CHARSET);
    }

    public void skipCString() {
        int nextNull = this.buffer.indexOf(this.buffer.readerIndex(), this.buffer.capacity(), (byte)0);
        if (nextNull == -1) {
            throw new AssertionError((Object)"Expected a CString but no '0' character found");
        }
        this.buffer.readerIndex(nextNull + 1);
    }

    public void skip(int numBytes) {
        this.ensureOpen();
        this.buffer.readerIndex(this.buffer.readerIndex() + numBytes);
    }

    public void mark(int readLimit) {
        this.ensureOpen();
        this.mark = this.buffer.readerIndex();
    }

    public void reset() {
        this.ensureOpen();
        if (this.mark == -1) {
            throw new IllegalStateException("Mark not set");
        }
        this.buffer.readerIndex(this.mark);
    }

    public boolean hasRemaining() {
        this.ensureOpen();
        return this.buffer.readableBytes() > 0;
    }

    public void close() {
        this.closed = true;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Input is closed");
        }
    }
}

