/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import org.bson.BsonSerializationException;
import org.bson.io.BsonOutput;
import org.bson.types.ObjectId;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="It seems FindBugs considers ByteBuf methods are not side effect")
public class ByteBufBsonOutputAdaptor
implements BsonOutput {
    private final ByteBuf buffer;
    private boolean closed = false;

    public ByteBufBsonOutputAdaptor(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public int getPosition() {
        this.ensureOpen();
        return this.buffer.writerIndex();
    }

    public int getSize() {
        this.ensureOpen();
        return this.buffer.writerIndex();
    }

    public void truncateToPosition(int newPosition) {
        this.ensureOpen();
        if (newPosition > this.buffer.writerIndex() || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer.writerIndex(newPosition);
    }

    public void writeBytes(byte[] bytes) {
        this.ensureOpen();
        this.buffer.writeBytes(bytes);
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.ensureOpen();
        this.buffer.writeBytes(bytes, offset, length);
    }

    public void writeByte(int value) {
        this.ensureOpen();
        this.buffer.writeByte(value);
    }

    public void writeCString(String value) {
        this.ensureOpen();
        this.writeCharacters(value, true);
    }

    public void writeString(String value) {
        this.ensureOpen();
        this.writeInt32(0);
        int strLen = this.writeCharacters(value, false);
        this.writeInt32(this.getPosition() - strLen - 4, strLen);
    }

    public void writeDouble(double value) {
        this.writeInt64(Double.doubleToRawLongBits(value));
    }

    public void writeInt32(int value) {
        this.ensureOpen();
        this.buffer.writeInt(value);
    }

    public void writeInt32(int position, int value) {
        this.ensureOpen();
        this.buffer.markWriterIndex().writerIndex(position).writeInt(value).resetWriterIndex();
    }

    public void writeInt64(long value) {
        this.ensureOpen();
        this.buffer.writeLong(value);
    }

    public void writeObjectId(ObjectId value) {
        this.writeBytes(value.toByteArray());
    }

    public void close() {
        this.closed = true;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("The output is closed");
        }
    }

    private int writeCharacters(String str, boolean checkForNullCharacters) {
        int c;
        int len = str.length();
        int total = 0;
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = Character.codePointAt(str, i);
            if (checkForNullCharacters && c == 0) {
                throw new BsonSerializationException(String.format("BSON cstring '%s' is not valid because it contains a null character at index %d", str, i));
            }
            if (c < 128) {
                this.writeByte((byte)c);
                ++total;
                continue;
            }
            if (c < 2048) {
                this.writeByte((byte)(192 + (c >> 6)));
                this.writeByte((byte)(128 + (c & 0x3F)));
                total += 2;
                continue;
            }
            if (c < 65536) {
                this.writeByte((byte)(224 + (c >> 12)));
                this.writeByte((byte)(128 + (c >> 6 & 0x3F)));
                this.writeByte((byte)(128 + (c & 0x3F)));
                total += 3;
                continue;
            }
            this.writeByte((byte)(240 + (c >> 18)));
            this.writeByte((byte)(128 + (c >> 12 & 0x3F)));
            this.writeByte((byte)(128 + (c >> 6 & 0x3F)));
            this.writeByte((byte)(128 + (c & 0x3F)));
            total += 4;
        }
        this.writeByte(0);
        return ++total;
    }
}

