/*
 * Decompiled with CFR 0.152.
 */
package com.eightkdata.mongowp.mongoserver.util;

import com.eightkdata.mongowp.mongoserver.util.ByteBufBsonInputAdaptor;
import com.eightkdata.mongowp.mongoserver.util.ByteBufBsonOutputAdaptor;
import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="It seems FindBugs considers ByteBuf methods are not side effect")
public class ByteBufUtil {
    public static final byte CSTRING_BYTE_TERMINATION = 0;
    private static final BsonDocumentCodec BSON_CODEC = new BsonDocumentCodec();

    public static String readCString(ByteBuf buffer) {
        int pos = buffer.bytesBefore((byte)0);
        if (pos == -1) {
            return null;
        }
        byte[] bytes = new byte[pos];
        buffer.readBytes(bytes);
        buffer.readByte();
        return new String(bytes, Charsets.UTF_8);
    }

    public static BsonDocument readBsonDocument(ByteBuf buffer) {
        BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new ByteBufBsonInputAdaptor(buffer));
        DecoderContext context = DecoderContext.builder().build();
        return BSON_CODEC.decode((BsonReader)reader, context);
    }

    public static void writeBsonDocument(ByteBuf buffer, BsonDocument bson) {
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)new ByteBufBsonOutputAdaptor(buffer));
        EncoderContext context = EncoderContext.builder().build();
        BSON_CODEC.encode((BsonWriter)writer, bson, context);
    }
}

