/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.admin.device;

import android.annotation.TargetApi;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.provider.Settings;
import android.view.Window;
import android.view.WindowManager;

@TargetApi(value=17)
public class DeviceTool {
    private DeviceTool() {
        throw new Error("Do not need instantiate!");
    }

    public static int getScreenBrightnessModeState(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode", (int)1);
    }

    public static boolean isScreenBrightnessModeAuto(Context context) {
        return DeviceTool.getScreenBrightnessModeState(context) == 1;
    }

    public static boolean setScreenBrightnessMode(Context context, boolean auto) {
        boolean result = true;
        if (DeviceTool.isScreenBrightnessModeAuto(context) != auto) {
            result = Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode", (int)(auto ? 1 : 0));
        }
        return result;
    }

    public static int getScreenBrightness(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness", (int)255);
    }

    public static boolean setScreenBrightness(Context context, int screenBrightness) {
        int brightness = screenBrightness;
        if (screenBrightness < 1) {
            brightness = 1;
        } else if (screenBrightness > 255 && (brightness = screenBrightness % 255) == 0) {
            brightness = 255;
        }
        return Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness", (int)brightness);
    }

    public static void setWindowBrightness(Activity activity, float screenBrightness) {
        float brightness = screenBrightness;
        if (screenBrightness < 1.0f) {
            brightness = 1.0f;
        } else if (screenBrightness > 255.0f && (brightness = screenBrightness % 255.0f) == 0.0f) {
            brightness = 255.0f;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams localLayoutParams = window.getAttributes();
        localLayoutParams.screenBrightness = brightness / 255.0f;
        window.setAttributes(localLayoutParams);
    }

    public static boolean setScreenBrightnessAndApply(Activity activity, int screenBrightness) {
        boolean result = true;
        result = DeviceTool.setScreenBrightness((Context)activity, screenBrightness);
        if (result) {
            DeviceTool.setWindowBrightness(activity, screenBrightness);
        }
        return result;
    }

    public static int getScreenDormantTime(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_off_timeout", (int)30000);
    }

    public static boolean setScreenDormantTime(Context context, int millis) {
        return Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"screen_off_timeout", (int)millis);
    }

    public static int getAirplaneModeState(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0);
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0);
    }

    public static boolean isAirplaneModeOpen(Context context) {
        return DeviceTool.getAirplaneModeState(context) == 1;
    }

    @TargetApi(value=17)
    public static boolean setAirplaneMode(Context context, boolean enable) {
        boolean result = true;
        if (DeviceTool.isAirplaneModeOpen(context) != enable) {
            result = Build.VERSION.SDK_INT < 17 ? Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)(enable ? 1 : 0)) : Settings.Global.putInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)(enable ? 1 : 0));
            context.sendBroadcast(new Intent("android.intent.action.AIRPLANE_MODE"));
        }
        return result;
    }

    public static int getBluetoothState() throws Exception {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            throw new Exception("bluetooth device not found!");
        }
        return bluetoothAdapter.getState();
    }

    public static boolean isBluetoothOpen() {
        int bluetoothStateCode = 0;
        try {
            bluetoothStateCode = DeviceTool.getBluetoothState();
            return bluetoothStateCode == 12 || bluetoothStateCode == 11;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setBluetooth(boolean enable) {
        if (DeviceTool.isBluetoothOpen() != enable) {
            if (enable) {
                BluetoothAdapter.getDefaultAdapter().enable();
            } else {
                BluetoothAdapter.getDefaultAdapter().disable();
            }
        }
    }

    public static int getRingVolume(Context context) {
        return ((AudioManager)context.getSystemService("audio")).getStreamVolume(2);
    }

    public static void setRingVolume(Context context, int ringVloume) {
        if (ringVloume < 0) {
            ringVloume = 0;
        } else if (ringVloume > 7 && (ringVloume %= 7) == 0) {
            ringVloume = 7;
        }
        ((AudioManager)context.getSystemService("audio")).setStreamVolume(2, ringVloume, 4);
    }
}

