/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.animation;

import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;

public final class AnimationUtils {
    public static final long DEFAULT_ANIMATION_DURATION = 400L;

    private AnimationUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static RotateAnimation getRotateAnimation(float fromDegrees, float toDegrees, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue, long durationMillis, Animation.AnimationListener animationListener) {
        RotateAnimation rotateAnimation = new RotateAnimation(fromDegrees, toDegrees, pivotXType, pivotXValue, pivotYType, pivotYValue);
        rotateAnimation.setDuration(durationMillis);
        if (animationListener != null) {
            rotateAnimation.setAnimationListener(animationListener);
        }
        return rotateAnimation;
    }

    public static RotateAnimation getRotateAnimationByCenter(long durationMillis, Animation.AnimationListener animationListener) {
        return AnimationUtils.getRotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f, durationMillis, animationListener);
    }

    public static RotateAnimation getRotateAnimationByCenter(long duration) {
        return AnimationUtils.getRotateAnimationByCenter(duration, null);
    }

    public static RotateAnimation getRotateAnimationByCenter(Animation.AnimationListener animationListener) {
        return AnimationUtils.getRotateAnimationByCenter(400L, animationListener);
    }

    public static RotateAnimation getRotateAnimationByCenter() {
        return AnimationUtils.getRotateAnimationByCenter(400L, null);
    }

    public static AlphaAnimation getAlphaAnimation(float fromAlpha, float toAlpha, long durationMillis, Animation.AnimationListener animationListener) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(fromAlpha, toAlpha);
        alphaAnimation.setDuration(durationMillis);
        if (animationListener != null) {
            alphaAnimation.setAnimationListener(animationListener);
        }
        return alphaAnimation;
    }

    public static AlphaAnimation getAlphaAnimation(float fromAlpha, float toAlpha, long durationMillis) {
        return AnimationUtils.getAlphaAnimation(fromAlpha, toAlpha, durationMillis, null);
    }

    public static AlphaAnimation getAlphaAnimation(float fromAlpha, float toAlpha, Animation.AnimationListener animationListener) {
        return AnimationUtils.getAlphaAnimation(fromAlpha, toAlpha, 400L, animationListener);
    }

    public static AlphaAnimation getAlphaAnimation(float fromAlpha, float toAlpha) {
        return AnimationUtils.getAlphaAnimation(fromAlpha, toAlpha, 400L, null);
    }

    public static AlphaAnimation getHiddenAlphaAnimation(long durationMillis, Animation.AnimationListener animationListener) {
        return AnimationUtils.getAlphaAnimation(1.0f, 0.0f, durationMillis, animationListener);
    }

    public static AlphaAnimation getHiddenAlphaAnimation(long durationMillis) {
        return AnimationUtils.getHiddenAlphaAnimation(durationMillis, null);
    }

    public static AlphaAnimation getHiddenAlphaAnimation(Animation.AnimationListener animationListener) {
        return AnimationUtils.getHiddenAlphaAnimation(400L, animationListener);
    }

    public static AlphaAnimation getHiddenAlphaAnimation() {
        return AnimationUtils.getHiddenAlphaAnimation(400L, null);
    }

    public static AlphaAnimation getShowAlphaAnimation(long durationMillis, Animation.AnimationListener animationListener) {
        return AnimationUtils.getAlphaAnimation(0.0f, 1.0f, durationMillis, animationListener);
    }

    public static AlphaAnimation getShowAlphaAnimation(long durationMillis) {
        return AnimationUtils.getAlphaAnimation(0.0f, 1.0f, durationMillis, null);
    }

    public static AlphaAnimation getShowAlphaAnimation(Animation.AnimationListener animationListener) {
        return AnimationUtils.getAlphaAnimation(0.0f, 1.0f, 400L, animationListener);
    }

    public static AlphaAnimation getShowAlphaAnimation() {
        return AnimationUtils.getAlphaAnimation(0.0f, 1.0f, 400L, null);
    }

    public static ScaleAnimation getLessenScaleAnimation(long durationMillis, Animation.AnimationListener animationListener) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f);
        scaleAnimation.setDuration(durationMillis);
        scaleAnimation.setAnimationListener(animationListener);
        return scaleAnimation;
    }

    public static ScaleAnimation getLessenScaleAnimation(long durationMillis) {
        return AnimationUtils.getLessenScaleAnimation(durationMillis, null);
    }

    public static ScaleAnimation getLessenScaleAnimation(Animation.AnimationListener animationListener) {
        return AnimationUtils.getLessenScaleAnimation(400L, animationListener);
    }

    public static ScaleAnimation getAmplificationAnimation(long durationMillis, Animation.AnimationListener animationListener) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        scaleAnimation.setDuration(durationMillis);
        scaleAnimation.setAnimationListener(animationListener);
        return scaleAnimation;
    }

    public static ScaleAnimation getAmplificationAnimation(long durationMillis) {
        return AnimationUtils.getAmplificationAnimation(durationMillis, null);
    }

    public static ScaleAnimation getAmplificationAnimation(Animation.AnimationListener animationListener) {
        return AnimationUtils.getAmplificationAnimation(400L, animationListener);
    }
}

