/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.animation;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.x91tec.appshelf.animation.AnimationUtils;

public final class ViewAnimationUtils {
    private ViewAnimationUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static void invisibleViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 4) {
            view.setVisibility(4);
            AlphaAnimation hiddenAlphaAnimation = AnimationUtils.getHiddenAlphaAnimation(durationMillis);
            hiddenAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)hiddenAlphaAnimation);
        }
    }

    public static void invisibleViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.invisibleViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void invisibleViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.invisibleViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void invisibleViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtils.invisibleViewByAlpha(view, durationMillis, false, null);
    }

    public static void invisibleViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.invisibleViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void invisibleViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.invisibleViewByAlpha(view, 400L, false, animationListener);
    }

    public static void invisibleViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtils.invisibleViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void invisibleViewByAlpha(View view) {
        ViewAnimationUtils.invisibleViewByAlpha(view, 400L, false, null);
    }

    public static void goneViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 8) {
            view.setVisibility(8);
            AlphaAnimation hiddenAlphaAnimation = AnimationUtils.getHiddenAlphaAnimation(durationMillis);
            hiddenAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)hiddenAlphaAnimation);
        }
    }

    public static void goneViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.goneViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void goneViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.goneViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void goneViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtils.goneViewByAlpha(view, durationMillis, false, null);
    }

    public static void goneViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.goneViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void goneViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.goneViewByAlpha(view, 400L, false, animationListener);
    }

    public static void goneViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtils.goneViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void goneViewByAlpha(View view) {
        ViewAnimationUtils.goneViewByAlpha(view, 400L, false, null);
    }

    public static void visibleViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 0) {
            view.setVisibility(0);
            AlphaAnimation showAlphaAnimation = AnimationUtils.getShowAlphaAnimation(durationMillis);
            showAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)showAlphaAnimation);
        }
    }

    public static void visibleViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.visibleViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void visibleViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.visibleViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void visibleViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtils.visibleViewByAlpha(view, durationMillis, false, null);
    }

    public static void visibleViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.visibleViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void visibleViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtils.visibleViewByAlpha(view, 400L, false, animationListener);
    }

    public static void visibleViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtils.visibleViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void visibleViewByAlpha(View view) {
        ViewAnimationUtils.visibleViewByAlpha(view, 400L, false, null);
    }

    public static void translate(final View view, float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, float cycles, long durationMillis, final boolean isBanClick) {
        TranslateAnimation translateAnimation = new TranslateAnimation(fromXDelta, toXDelta, fromYDelta, toYDelta);
        translateAnimation.setDuration(durationMillis);
        if ((double)cycles > 0.0) {
            translateAnimation.setInterpolator((Interpolator)new CycleInterpolator(cycles));
        }
        translateAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                if (isBanClick) {
                    view.setClickable(false);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (isBanClick) {
                    view.setClickable(true);
                }
            }
        });
        view.startAnimation((Animation)translateAnimation);
    }

    public static void translate(View view, float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, float cycles, long durationMillis) {
        ViewAnimationUtils.translate(view, fromXDelta, toXDelta, fromYDelta, toYDelta, cycles, durationMillis, false);
    }

    public static void shake(View view, float fromXDelta, float toXDelta, float cycles, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.translate(view, fromXDelta, toXDelta, 0.0f, 0.0f, cycles, durationMillis, isBanClick);
    }

    public static void shake(View view, float fromXDelta, float toXDelta, float cycles, long durationMillis) {
        ViewAnimationUtils.translate(view, fromXDelta, toXDelta, 0.0f, 0.0f, cycles, durationMillis, false);
    }

    public static void shake(View view, float cycles, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, durationMillis, isBanClick);
    }

    public static void shake(View view, float cycles, boolean isBanClick) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, 700L, isBanClick);
    }

    public static void shake(View view, float cycles, long durationMillis) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, durationMillis, false);
    }

    public static void shake(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, durationMillis, isBanClick);
    }

    public static void shake(View view, float cycles) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, 700L, false);
    }

    public static void shake(View view, long durationMillis) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, durationMillis, false);
    }

    public static void shake(View view, boolean isBanClick) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, 700L, isBanClick);
    }

    public static void shake(View view) {
        ViewAnimationUtils.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, 700L, false);
    }
}

